C*******************************************************************
C*  FOR REFERENCE, CITE:                                           *   
C*    HAMILTON,M.A., R.C. RUSSO, AND R.V. THURSTON.  1977.         *   
C*    TRIMMED SPEARMAN-KARBER METHOD FOR ESTIMATING MEDIAN         *   
C*    LETHAL CONCENTRATIONS IN TOXICITY BIOASSAYS.  ENVIRON. SCI.  *   
C*    TECHNOL. 11(7): 714-719.   CORRECTION 12(4): 417 (1978)      *   
C*             --                                                  *   
C* THIS LISTING DESCRIBES THE FORTRAN SUBPROGRAMS FOR CALCULATING  *    
C* THE TRIMMED SPEARMAN-KARBER ESTIMATE OF THE LC50 WHICH WAS IN   *    
C* USE AT THE FISHERIES BIOASSAY LABORATORY, MONTANA STATE UNIV.,  *    
C* BOZEMAN AS OF JUNE, 1978. THE FISHERIES BIOASSAY LABORATORY     *    
C* ASSUMES NO RESPONSIBILITY FOR THE TECHNICAL ACCURACY OF THESE   *    
C* PROGRAMS.  APPROPRIATE INPUT-OUTPUT ROUTINES MUST BE SUPPLIED   *
C* BY THE USER.                                                    *
C* PROGRAMMERS: M.A. HAMILTON AND S.M. HINKINS.                    *       
C*                                                                 *   
C* MODIFIED JUNE 1980 BY BRAD GREENWOOD TO ALLOW FOR AUTOMATIC     *
C* TRIM OPTION.                                                    *
C*                                                                 *
C* MODIFIED BY C.A. STIDLEY JUNE 1982:  DOCUMENTATION ADDED,       *
C* MORE DESCRIPTION OF EXPERIMENT INCLUDED (TEST NUM, HOUR,        *
C* SPECIES, CHEMICAL, UNITS OF CONCENTRATIONS) IN INPUT AND OUTPUT,*
C* MESSAGE WHEN VARIANCE NOT CALCULABLE RATHER THAN TREATING       *
C* IT AS A ZERO VARIANCE, OTHER MINOR INFORMATIVE MESSAGES,        *
C* CHANGED METHOD OF CALCULATING MINIMUM NEEDED TRIM, SOME         *
C* INPUT/OUTPUT OPTION CHANGES.                                    *
C*                                                                 *
C* FURTHER MODIFICATIONS MADE 9&10/82 BY C.A.STIDLEY. SOME         *
C* WORDINGS WERE CHANGED; ORDER OF SOME OF THE QUESTIONS WAS       * 
C* CHANGED; THE LOOPING PROCEDURE WAS MODIFIED---ONE OF THE        *
C* RESULTS IS THAT A NEW EXPERIMENT CAN BE ANALYZED WITHOUT        *
C* HAVING TO EXIT THE PROGRAM FIRST; A CHANGE IN READING THE       *
C* CONCENTRATIONS WAS MADE SO THAT IT WOULD CORRECTLY REJECT A 0   *
C* CONCENTRATION; THE OPTION TO CREATE A PLOT AND SUMMARY FILE WAS *    
C* ADDED; TEST NUMBER WAS MADE A CHARACTER VARIABLE RATHER THAN AN *
C* INTEGER.                                                        *
C*                                                                 *
C* FURTHER MODIFICATIONS MADE 10/21/82 BY C.A.STIDLEY TO MAKE      *
C* THE DIMENSIONS OF DATE, CHEMICAL, & SPECIES THE SAME AS         *
C* USED IN ANOTHER PROGRAM. (DATE ALSO MADE A CHARACTER VARIABLE). *
C*                                                                 *
C* A COUPLE OF MODIFICATIONS WERE MADE 12/82 BY C.A.STIDLEY.       *
C* A CORRECTION WAS MADE IN THE REFERENCE AND THE FORMATS FOR THE  *
C* LC50 AND CONFIDENCE INTERVAL (FORMATS 820, 830, & 835) WERE     *
C* CHANGED.                                                        *
C*                                                                 *
C* Modified DATE field format for Year 2000 (Y2K) compliance.      *
C* Date: Monday, 4 January 1999.  Time: 14:30:34.                  *
C* D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA   *
C*******************************************************************   
C
C--
C MAIN PROGRAM TO PERFORM 100A% TRIMMED SPEARMAN-KARBER CALCULATIONS.      
C CALLS MNTN AND SKA.                       
C ANALYSIS OF LOG(CONCENTRATION).               
C--
C *************************************************************************
C
      PROGRAM MAIN
C
C   VARIABLES
C
      IMPLICIT REAL*8 (A-H,O-Z)   
	implicit integer*2 (i-n)
	INTEGER*2 INDICL,HOUR,ANSFL,
     1		P,NS,NC,NU,NUD,NF,NT,INDICF,ND
C
C---Modified DATE field format for Year 2000 (Y2K) compliance.
C   Date: Monday, 4 January 1999.  Time: 14:30:34.
C---D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA
C
      CHARACTER ANSLP,PLOTAN,FILEA2,LORE,FLAG
      CHARACTER*8 TEST,UNIT,UNITD
      CHARACTER*10 DATE
      CHARACTER*22 SPECIE,FIL
      CHARACTER*46 CHEM
C     character CHEM*46,SPECIE*22,UNIT*8,UNITD*8,FIL*22,    
C     1		ANSLP,PLOTAN,FILEA2,LORE,FLAG,TEST*8,DATE*10
C     1		ANSLP,PLOTAN,FILEA2,LORE,FLAG,TEST*8,DATE*8
      DIMENSION X(10),X1(10),N(10),P(10),PT(10),PT1(10)         
C--
C +++++ FORTRAN 77 CHANGE
C +     The following LOGICAL declaration statement replaced
C +     to conform to FORTRAN 77 standards.
C +     D. Disney - CSC for US EPA - Athens ERL (404)/546-3123
C +
C	LOGICAL*2 FLAGT1,FLAGT2,INDICC,ADJPRO,ADJTRM
C +
        LOGICAL*1 FLAGT1,FLAGT2,INDICC,ADJPRO,ADJTRM
C +
C +++++ END OF CHANGE
C--
C *	*	*	*	*	*	*	*	*	*
C
C  DESCRIPTION OF VARIABLES
C
C	X1(I)	CONCENTRATIONS (ORIGINAL)
C	X(I)	LOGE CONCENTRATIONS
C
C	K	NUMBER OF CONCENTRATIONS
C	KT	NUMBER OF INDIVIDUALS/CONCENTRATION, WHEN NUMBERS ARE  
C		SAME FOR EACH CONCENTRATION
C	N(I)	NUMBER OF INDIVIDUALS AT CONCENTRATION I
C
C	P(I)	NUMBER OF MORTALITIES FOR CONCENTRATION I
C	PT(I)	MORTALITY PROPORTION FOR CONCENTRATION I     
C		(CALCULATED AND THEN ADJUSTED TO BE MONOTONICALLY 
C		INCREASING)
C	PT1(I)	MORTALITY PROPORTION FOR CONCENTRATION I 
C		(ORIGINAL---NOT ADJUSTED TO BE MONOTONICALLY INCREASING)
C
C	AMIN	MINIMUM TRIM CALCULATED
C	AREQ	REQUESTED TRIM (=0, IF AUTOMATIC REQUESTED)
C	AUSE	TRIM USED (=MAXIMUM OF AMIN, AREQ)
C	A	USED TRIM GIVEN IN PERCENT (TRIMS ABOVE GIVEN IN PROPORTION)
C	AREQP	REQUESTED TRIM IN PERCENT
C	AMINP	MINIMUM TRIM IN PERCENT
C
C	FILE(X)	  NAME OF FILE FOR PLOT/SUMMARY OUTPUT
C
C	VARIABLES DESCRIBING EXPERIMENT:
C
C---Modified DATE field format for Year 2000 (Y2K) compliance.
C   Date: Monday, 4 January 1999.  Time: 14:30:34.
C---D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA
C
C	  DATE			DATE EXPERIMENT WAS RUN (A 10-CHARACTER VARIABLE)
CC       DATE			DATE EXPERIMENT WAS RUN (AN 8-CHARACTER VARIABLE)
C	  SPECIE		SPECIES NAME
C	  CHEM			CHEMICAL NAME
C	  UNIT			UNITS FOR CHEMICAL CONCENTRATION
C	  UNITD			UNITS FOR DURATION 
C	  TEST			TEST NUMBER  (IN CHARACTER FORM)
C	  HOUR			HOUR OF TEST  (DURATION OF TEST)
C
C	NUMBER OF CHARACTERS IN NAMES AND UNITS  (NOTE, THESE ARE USED
C		IN READING THE DATA, BUT ONLY NU AND NUD ARE USED LATER
C		---THEY ARE USED IN WRITING OUT THE UNITS.):
C	NF		NUMBER OF CHARACTERS IN PLOT/SUMMARY FILE NAME
C	NS		NUMBER OF CHARACTERS IN SPECIES NAME
C	NC		NUMBER OF CHARACTERS IN CHEMICAL NAME
C	NU		NUMBER OF CHARACTERS IN UNITS FOR CHEMICAL
C	NUD		NUMBER OF CHARACTERS IN UNITS FOR DURATION
C	NT		NUMBER OF CHARACTERS IN THE TEST NUMBER
C	ND		NUMBER OF CHARACTERS IN DATE
C
C
C	INDICATORS:
C	  FLAGT1  TRUE IF HAVE NOT ASKED IF WANT AUTOMATIC TRIM---
C		  I.E., IT'S TRUE FOR ONLY THE FIRST PASS THROUGH.
C	  FLAGT2  TRUE IF WANT AUTOMATIC TRIM
C	  FLAG	  FLAG USED THROUGHOUT FOR VARIOUS QUESTIONS
C	  ADJPRO  INDICATOR AS TO WHETHER OR NOT PROPORTIONS HAD TO BE
C		  ADJUSTED.
C	  ADJTRM  INDICATOR AS TO WHETHER OR NOT REQUESTED TRIM HAD TO 
C		  BE ADJUSTED.
C	  INDICL  INDICATOR CONCERNING LINE PRINTER.  EQUALS NUMBER OF TIMES
C		  PRINT SOMETHING (NEED THIS, SINCE PRINT THE REFERENCE ONLY
C		  THE FIRST TIME SOMETHING IS PRINTED).
C	  INDICC  INDICATOR AS TO WHETHER OR NOT 95% CONFIDENCE INTERVAL
C		  IS CALCULABLE.
C	  ANSLP   ANSWER CONCERNING OUTPUTTING TO THE LINE PRINTER
C	  PLOTAN  ANSWER CONCERNING CREATION OF A PLOT/SUMMARY FILE
C	  FILEA2  ANSWER CONCERNING WHETHER A PARTICULAR LC50, ETC.
C		  SHOULD BE WRITTEN TO THE OUTPUT FILE
C	  INDICF  INDICATOR USED TO DETERMINE IF HEADER SHOULD
C		  BE WRITTEN TO OUTPUT FILE (HEADER IS WRITTEN
C		  ON THE FILE ONLY THE FIRST TIME THROUGH).
C	  LORE	  INDICATES LC50 OR EC50
C
C *	*	*	*	*	*	*	*	*	*
C
50	FORMAT(A1)
C
C
C  REFERENCE FOR SPEARMAN-KARBER PROCEDURE
C
	write(*,70)
70	FORMAT(/' TRIMMED SPEARMAN-KARBER METHOD.  MONTANA STATE UNIV',//)
	write(*,80)
80	FORMAT('  FOR REFERENCE, CITE:'/
     1	   '  HAMILTON, M.A., R.C. RUSSO, AND R.V. THURSTON, 1977.',/
     2	   '  TRIMMED SPEARMAN-KARBER METHOD FOR ESTIMATING MEDIAN',/
     3	   '  LETHAL CONCENTRATIONS IN TOXICITY BIOASSAYS.',/
     4	   '  ENVIRON. SCI. TECHNOL. 11(7): 714-719;',/
     5	   '  CORRECTION 12(4):417  (1978).'//)
C--
C--
C
C  INITIALIZE FLAGS AND INDICATORS
C
150	FLAGT1=.TRUE.
C
	INDICL=0
	INDICF=0
C
C
C
C  DETERMINING IF THERE WILL BE A PLOT/SUMMARY FILE
C
160	write(*,170)
170	  FORMAT('  WOULD YOU LIKE TO CREATE A PLOT AND SUMMARY',
     1		' FILE(Y/N)?   ')
	  READ(*,50,ERR=160)PLOTAN
	   IF(PLOTAN.EQ.'N')GO TO 200
	   IF(PLOTAN.NE.'Y')GO TO 160
C
C    NEED AN OUTPUT FILE:
C
180	write(*,190)
190	  FORMAT('  NAME OF PLOT AND SUMMARY FILE TO BE CREATED:   ')
	  READ(*,195,ERR=180) FIL
195	   FORMAT(A)
	OPEN(UNIT=2,FILE=FIL,STATUS='UNKNOWN')
C
C
C
C************************************************************************   
C               
C  OBTAINING INFORMATION ABOUT THE EXPERIMENT
C
C   DATE
C
C     INITIALIZE DATE
C
C---Modified DATE field format for Year 2000 (Y2K) compliance.
C   Date: Monday, 4 January 1999.  Time: 14:30:34.
C---D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA
C
	DO 199 I=1,10
	  DATE(I:I)=' '
199	CONTINUE
C	DO 199 I=1,8
C	  DATE(I:I)=' '
C199	CONTINUE
C
200	write(*,205)
205	 FORMAT('  ENTER DATE OF TEST:  ')
	 READ(*,210,ERR=200) DATE
210	 FORMAT(A)
C
C   INITIALIZE SPECIES AND CHEMICAL NAMES, UNITS, AND TEST NUMBER:
	DO 215 J=1,46
	  CHEM(J:J)=' '
215	CONTINUE
	DO 220 J=1,22
	  SPECIE(J:J)=' '
220	CONTINUE
C
	DO 230 J=1,8
	  UNIT(J:J)=' '
	  UNITD(J:J)=' '
	  TEST(J:J)=' '
230	CONTINUE
C
C
C  OBTAINING TEST NUMBER:
C
235	write(*,240)
240	 FORMAT('  ENTER TEST NUMBER:  ')
	 READ(*,245,ERR=235) TEST
245	 FORMAT(A)
C
C  WHETHER AN LC50 OR EC50
C
250	write(*,255)
255	  FORMAT('  WHAT IS TO ESTIMATED:'
     1		/'       (L)  LC50'
     2		/'   OR  (E)  EC50 ?   ')
	  READ(*,50,ERR=250)LORE
	   IF((LORE.NE.'L').AND.(LORE.NE.'E'))GO TO 250
C
260	write(*,265)
265	 FORMAT('  ENTER SPECIES NAME:  ')
	 READ(*,270,ERR=260) SPECIE
270	 FORMAT(A)
C
275	write(*,280)
280	 FORMAT('  ENTER CHEMICAL NAME:  ')
	 READ(*,285,ERR=275) CHEM
285	 FORMAT(A)
C
290	write(*,295)
295	 FORMAT('  ENTER UNITS FOR CONCENTRATION OF CHEMICAL:  ')
	 READ(*,300,ERR=290) UNIT
	DO 296 I=8,1,-1
	   NU=I
	   IF(UNIT(I:I).NE.' ') GO TO 297
296	CONTINUE
297	CONTINUE
300	 FORMAT(A)
C
C
C* *****************************************************************    
C
C	*	*	*	*	*	*	*	*	*
C
C
C  READING IN DATA ALONG WITH PRELIMINARY CALCULATIONS AND CHECKS
C
C
C
C  OBTAINING NUMBER OF CONCENTRATIONS  (K)
C
350	write(*,355)
355	FORMAT('  ENTER THE NUMBER OF CONCENTRATIONS:  ')
	READ(*,*,ERR=350)K
C
C   CHECK TO SEE IF NUMBER OF CONCENTRATIONS IS WITHIN RANGE
	 IF((K.GT.1).AND.(K.LT.11))GO TO 365
	   write(*,360)
360	    FORMAT('  ERROR.  NUMBER OF CONCENTRATIONS NOT ALLOWED.',
     *			' (MAX=10.)',/)
	   GO TO 350
C
C
C  OBTAINING CONCENTRATIONS   ( X1(I) AND X(I) )
C
365	write(*,370) K
370	 FORMAT('  ENTER THE',I3,' CONCENTRATIONS (IN INCREASING',
     1		' ORDER):',/)
	 READ(*,*,ERR=365)(X1(I),I=1,K)
C
C   CHECKS ON CONCENTRATIONS:
C
C    (1) CONCENTRATIONS SHOULD BE IN INCREASING ORDER (IF NOT, POSSIBLY 
C	 A TYPO):
	DO 380 I=1,K-1
	   IF(X1(I).LT.X1(I+1))GO TO 380	
C	   NOT INCREASING ORDER:
		write(*,375)
375		FORMAT('  CONCENTRATIONS NOT IN INCREASING ORDER.  ',
     *			'REENTER.')
		GO TO 365
380	CONTINUE
C
C    (2) ONLY POSITIVE CONCENTRATIONS---NO NEGATIVE OR ZERO CONCENTRATIONS
C
	IF(X1(1).GT.1.0D-8)GO TO 390  
	write(*,385)
385	 FORMAT('  USE ONLY POSITIVE CONCENTRATIONS: DO NOT USE',
     1		' CONTROL OR NEGATIVE NUMBERS.'
     2		/,'  REENTER CONCENTRATION INFORMATION.',/)
	GO TO 350
C
C     OBTAIN NATURAL LOG OF THE CONCENTRATIONS
390	DO 395 I=1,K
	   X(I)=DLOG(X1(I))
395	CONTINUE
C
C *	*	*	*	*	*	*	*	*	*
C
C  OBTAINING NUMBER OF INDIVIDUALS AT EACH CONCENTRATION   ( N(I) )
C
C
C   IF HAVE EQUAL NUMBER OF INDIVIDUALS AT EACH CONCENTRATION, THE  
C   FOLLOWING GIVES A SHORT-CUT IN DATA ENTRY.
410	  write(*,415)
415	 FORMAT('  ARE THE NUMBER OF INDIVIDUALS AT EACH CONCENTRATION',
     1			' EQUAL(Y/N)?  ')
	   READ(*,50,ERR=410)FLAG
	   IF(FLAG.EQ.'N')GO TO 460
	   IF(FLAG.NE.'Y')GO TO 410      
C
C    NOW WILL DO THE FOLLOWING ONLY IF FLAG=YES,  THAT IS, IF THE NUMBER
C    AT EACH CONCENTRATION ARE EQUAL.
420	write(*,425)
425	  FORMAT('  ENTER THE NUMBER OF INDIVIDUALS AT EACH ',
     1		'CONCENTRATION:  ')
	  READ(*,*,ERR=420)KT
	IF(KT.GT.0)GO TO 440
C    IF NUMBER/CONCENTRATION <=0 THEN:
	write(*,430)
430	 FORMAT('  ERROR IN NUMBER/CONCENTRATION',/,
     1          '  (MUST BE GREATER THAN ZERO).',/)
	 GO TO 420
C    NOW SET ALL NUMBERS/CONCENTRATION = KT
440	 DO 450 I=1,K
	   N(I)=KT
450	 CONTINUE
	GO TO 485   
C
C
C  NOW, IF THE NUMBER OF INDIVIDUALS PER CONCENTRATION ARE UNEQUAL, NEED 
C  TO ENTER INDIVIDUAL NUMBERS:
460	 write(*,465)
465	  FORMAT('  ENTER THE NUMBER OF INDIVIDUALS AT EACH',
     1		' CONCENTRATION: ',/)
	  READ(*,*,ERR=460)(N(I),I=1,K)
C   CHECK TO SEE IF ALL NUMBERS OF INDIVIDUALS ARE POSITIVE 
	DO 480 I=1,K
	 IF(N(I).GT.0)GO TO 480
	 write(*,470)
470	 FORMAT('  ERROR IN NUMBERS (MUST BE GREATER THAN ZERO).',/)
	GO TO 460
480	CONTINUE
C	*	*	*	*	*	*	*	*	*
C
C   DURATION
C
C
485	write(*,490)
490	 FORMAT('  ENTER UNITS FOR DURATION OF EXPERIMENT',
     *		'(HOURS,DAYS,ETC.):  ')
	 READ(*,495,ERR=485) UNITD
495	 FORMAT(A)
C
500	write(*,505)
505	  FORMAT('  ENTER DURATION OF TEST:  ')
	   READ(*,*,ERR=500)HOUR
C
C
C	*	*	*	*	*	*	*	*	*	*
C
C
C  OBTAINING NUMBER OF MORTALITIES FOR EACH CONCENTRATION
C
510	write(*,515)
515	 FORMAT('  ENTER THE NUMBER OF MORTALITIES AT EACH',
     1		' CONCENTRATION: ',/)
	 READ(*,*,ERR=510)(P(I),I=1,K)
C
C   CHECK TO SEE IF ALL NUMBER OF MORTALITIES ARE NON-NEGATIVE AND
C   THAT ALL NUMBER OF MORTALITIES ARE <= NUMBER OF INDIVIDUALS
	DO 530 I=1,K
	   IF(P(I).LT.0)write(*,520)
520	    FORMAT('  ERROR IN NUMBER OF MORTALITIES',/,
     1             '  (MUST BE NON-NEGATIVE).',/)
	   IF(P(I).GT.N(I))write(*,525)
525	    FORMAT('  ERROR IN NUMBER OF MORTALITIES (NUMBER OF',
     1		' MORTALITIES',/,'  CANNOT BE GREATER THAN NUMBER OF',
     2		' INDIVIDUALS).',/)
	  IF((P(I).LT.0).OR.(P(I).GT.N(I)))GO TO 510
530	CONTINUE
C	*	*	*	*	*	*	*	*	*
C
C   TO CALCULATE MORTALITY PROPORTIONS:
C
	DO 560 I=1,K
C	  PT(I)=DFLOAT(P(I))/DFLOAT(N(I))
	  PT(I)=DBLE(P(I))/DBLE(N(I))
	  PT1(I)=PT(I)
560	CONTINUE
C
C    ADJUST PROPORTIONS TO BE MONOTONE NONDECREASING    
	CALL MNTN(K,N,PT)
C
C *	*	*	*	*	*	*	*	*	*
C
C
C    TRIM
C
C  IF HAVE ALREADY ASKED IF AUTOMATIC TRIM IS WANTED, SKIP THIS SECTION:
600	IF(.NOT.FLAGT1)GO TO 615
	FLAGT1=.FALSE.
C
	AREQ=0.0D0
C
605	write(*,610)
610	 FORMAT('  WOULD YOU LIKE THE AUTOMATIC TRIM',
     1		' CALCULATION(Y/N)?  ')
	 READ(*,50,ERR=605)FLAG
	IF((FLAG.NE.'Y').AND.(FLAG.NE.'N'))GO TO 605
C
	FLAGT2=.FALSE.
	IF(FLAG.EQ.'Y')FLAGT2=.TRUE.
C
615	IF(FLAGT2)GO TO 650    
C
620	write(*,625)
625	 FORMAT('  ENTER THE % TRIM REQUESTED:  ')
	 READ(*,*,ERR=620)AREQ
C   0<=TRIM<=50
	IF(.NOT.((AREQ.LT.0).OR.(AREQ.GT.50)))GO TO 640
	 write(*,630)
630	  FORMAT('  CHOSEN TRIM NOT ALLOWED.')
	GO TO 620
640	AREQ=AREQ*.01D0   
C
C
C
C   CALL 100A% TRIMMED SPEARMAN-KARBER ESTIMATOR SUBPROGRAM    
C    AUTOMATIC TRIM CALCULATIONS
650	AMIN=PT(1)
	IF((1.0D0-PT(K)).GE.PT(1))AMIN=1.0D0-PT(K)
	IF(AMIN.GT.0.5D0) GO TO 980
C
C
C    NOW HAVE AMIN AND AREQ
C
C     OVERRIDE REQUESTED TRIM ONLY IF IT'S NOT LARGE ENOUGH
	AUSE=AMIN
	IF(AREQ.GT.AMIN)AUSE=AREQ
C
C    FIND SPEARMAN-KARBER ESTIMATES USING AUSE AS TRIM:
      CALL SKA(EMU,VMU,AUSE,K,X,N,PT,INDICC)      
C
 	SD=DSQRT( DABS(VMU) )      
      ELO=EMU-2.D0*SD                         
      EUP=EMU+2.D0*SD                                          
C********************************************************   
C*                                                      *   
C*  IF DESIRED, INSERT HERE THE CODE TO OUTPUT THE      *   
C*  ESTIMATES,C.I.,ETC ON THE NATURAL LOG SCALE         *   
C*                                                      *   
C********************************************************   
      SK=DEXP(EMU)   
      ELO=DEXP(ELO)   
      EUP=DEXP(EUP)   
C********************************************************   
C*                                                      *    
C*  INSERT HERE THE CODE TO OUTPUT THE ESTIMATE OF      *    
C*  LC50(SK) AND THE ESTIMATED 95% CONFIDENCE INTERVAL  *    
C*  (ELO & EUP).                                        *   
C*                                                      *   
C--
800	A=AUSE*100.           
C   HEADING:
C	write(*,810)(DATE(I),I=1,8),(TEST(I),I=1,8),HOUR,(UNITD(I),
C     1	  I=1,NUD),(CHEM(J),J=1,46),(SPECIE(J),J=1,22)
C
C---Modified DATE field format for Year 2000 (Y2K) compliance.
C   Date: Monday, 4 January 1999.  Time: 14:30:34.
C---D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA
C
      write(*,810) date,test,hour,unitd,chem,specie
810	FORMAT(//'  DATE:   ',A,9X,'TEST NUMBER: ',
     1	  A,10X,'DURATION:',I5,1X,A,/'  CHEMICAL:  ',A,
     2	   ' SPECIES:  ',A)
C      write(*,810) date,test,hour,unitd,chem,specie
C810	FORMAT(//'  DATE:   ',A,11X,'TEST NUMBER: ',
C     1	  A,10X,'DURATION:',I5,1X,A,/'  CHEMICAL:  ',A,
C     2	   ' SPECIES:  ',A)
C
C	write(*,820) UNIT,(X1(I),I=1,K),(N(I),I=1,K),
C     1		(P(I),I=1,K),A,LORE,SK
C820	FORMAT(//'  RAW DATA:'
C     1		/,'    CONCENTRATION(',A,')',T30,<K>F7.2,
C     2		/,'    NUMBER EXPOSED:',T30,<K>I7,
C     3		/,'    MORTALITIES:',T30,<K>I7,
C     4		/,'    SPEARMAN-KARBER TRIM: ',10X,F7.2,'%',
C     5		//,'   SPEARMAN-KARBER ESTIMATES:',5X,A1,'C50:',
C     6                 3X,F12.2)
C
	write(*,820) UNIT(1:NU),(X1(I),I=1,K)
	write(*,821) (N(I),I=1,K)
	write(*,822) (P(I),I=1,K)
	write(*,823) A,LORE,SK
820	FORMAT(//'  RAW DATA:'
     +		/,'    CONCENTRATION(',A,')',T30,10F7.2)
821	format('    NUMBER EXPOSED:',T30,10I7)
822	format('    MORTALITIES:',T30,10I7)
823	format('    SPEARMAN-KARBER TRIM: ',10X,F7.2,'%',
     +        //,'   SPEARMAN-KARBER ESTIMATES:',5X,A1,'C50:',3X,F12.2)
C
C   IF CANNOT CALCULATE 95% CONFIDENCE INTERVALS, OUTPUT CI LINES
C   DIFFERENTLY:
	IF(INDICC)write(*,830)ELO,EUP
	IF(.NOT.INDICC)write(*,835)
830	 FORMAT('                  95% LOWER CONFIDENCE:',3X,F12.2,
     1		/,'                  95% UPPER CONFIDENCE:',3X,F12.2)
835	 FORMAT(42X,'95% CONFIDENCE LIMITS ',/,42X,
     1		'ARE NOT RELIABLE.')
C
C  IF PROPORTIONS WERE ADJUSTED TO MAKE THEM MONOTONICALLY INCREASING, 
C  THEN MESSAGE WILL BE OUTPUTTED.
C  TO DETERMINE IF THIS MESSAGE IS NEEDED:
	ADJPRO=.FALSE.
	DO 840 I=1,K
	  IF(DABS(PT(I)-PT1(I)).GT.1.0D-8)ADJPRO=.TRUE.
	  IF(ADJPRO)GO TO 845
840	CONTINUE
845	IF(ADJPRO)write(*,850)
850	FORMAT(/'  NOTE:  MORTALITY PROPORTIONS WERE NOT',
     1		' MONOTONICALLY INCREASING.',/,9X,'ADJUSTMENTS',
     2		' WERE MADE PRIOR TO SPEARMAN-KARBER ESTIMATION.')
C
C
C
C  IF A TRIM VALUE IS ENTERRED, BUT THE REQUIRED MINIMUM TRIM IS
C  LARGER, THEN THE REQUIRED MINIMUM TRIM WILL BE USED.  HOWEVER,
C  A MESSAGE WILL BE OUTPUTTED.
C  TO DETERMINE IF THIS MESSAGE IS NEEDED:
C
	ADJTRM=.FALSE.
	IF(FLAGT2) GO TO 870
	  IF((AMIN-AREQ).GT.1.0D-8)ADJTRM=.TRUE.
	 AREQP=AREQ*100.
	 AMINP=AMIN*100.
	IF(ADJTRM)write(*,860)AREQP,AMINP
860	FORMAT(/'  NOTE:  REQUESTED TRIM OF ',F5.2,'% IS TOO',
     1		' SMALL.',/,9X,'CALCULATED TRIM OF ',F5.2,'% WAS USED.')
C
C
C   FINISH OUTPUT:
870	write(*,875)
875	FORMAT(1X,80('-'),//)
C
C  DETERMINE IF RESULTS WILL BE PRINTED
C
880	write(*,885)
885	 FORMAT('  WOULD YOU LIKE TO HAVE A COPY SENT TO THE ',
     1		'PRINTER(Y/N)?  ')
	 READ(*,50,ERR=880)ANSLP
	   IF(ANSLP.EQ.'N')GO TO 891
	   IF(ANSLP.NE.'Y') GO TO 880
C
C  REFERENCE IS PRINTED ONLY THE FIRST TIME SOMETHING IS PRINTED.
C  INDICL IS USED TO DETERMINE IF THE REFERENCE SHOULD BE PRINTED.
C
	INDICL=INDICL+1
	IF(INDICL.GT.1) GO TO 890
	open(7,file='prn',form='formatted',access='sequential')
C
C   PRINTING OUT INFO
	write(7,70)
	write(7,80)
890	write(7,810) date,test,hour,unitd,chem,specie
c
c	write(7,820) unit,(X1(I),I=1,K),(N(I),I=1,K),
c     1		(P(I),I=1,K),A,LORE,SK
c
	write(7,820) UNIT(1:NU),(X1(I),I=1,K)
	write(7,821) (N(I),I=1,K)
	write(7,822) (P(I),I=1,K)
	write(7,823) A,LORE,SK
C   IF CANNOT CALCULATE 95% CONFIDENCE INTERVALS, OUTPUT CI LINES
C   DIFFERENTLY:
	IF(INDICC) write(7,830) ELO,EUP
	IF(.NOT.INDICC) write(7,835)
C   PRINTING OUT MESSAGES:
	IF(ADJPRO) write(7,850)
	IF(ADJTRM) write(7,860) AREQP,AMINP
C
	write(7,875)
C
C  DETERMINE IF THIS SHOULD BE PUT INTO THE PLOT/SUMMARY FILE
C
891	IF(PLOTAN.NE.'Y')GO TO 900
C
C    IF FIRST TIME THROUGH, WRITE-OUT HEADER
C
	INDICF=INDICF+1
	  IF(INDICF.GT.1)GO TO 895
C     
C     HEADER:
C
	WRITE(2,70)
	WRITE(2,80)
C
C---Modified DATE field format for Year 2000 (Y2K) compliance.
C   Date: Monday, 4 January 1999.  Time: 14:30:34.
C---D Disney, Senior Systems Analyst, OAO Corporation, Athens, GA
C
	WRITE(2,892)(DATE(I:i),I=1,10),(TEST(I:i),I=1,8),
     1		(CHEM(J:j),J=1,46),(SPECIE(J:j),J=1,22)
892	 FORMAT(//'  DATE:   ',10A1,39X,'TEST NUMBER: ',8A1,
     1	   /,'  CHEMICAL: ',46A1,' SPECIES: ',22A1)
C	WRITE(2,892)(DATE(I:i),I=1,8),(TEST(I:i),I=1,8),
C     1		(CHEM(J:j),J=1,46),(SPECIE(J:j),J=1,22)
C892	 FORMAT(//'  DATE:   ',8A1,41X,'TEST NUMBER: ',8A1,
C     1	   /,'  CHEMICAL: ',46A1,' SPECIES: ',22A1)
	WRITE(2,893) (UNIT(I:i),I=1,8),(X1(I),I=1,K)
	write(2,894) (N(I),I=1,K)
	write(2,8945) (UNITD(I:i),I=1,8),LORE
893	FORMAT(//'  RAW DATA:'
     +		/,'    CONCENTRATION(',8A1,')',T30,10F7.2)
894	format('    NUMBER EXPOSED:',T30,10I7)
8945	format(/,'  DURATION (',8A1,')',7X,A1,'C50    '
     +		,'LOWER 95% LIMIT    UPPER 95% LIMIT   PERCENT TRIM',/)
C
C   NEED TO SEE IF THIS POINT'S INFO SHOULD BE SAVED:
C
895	write(*,896)
896	  FORMAT('  WOULD YOU LIKE TO SAVE THESE RESULTS IN THE',
     1		 ' PLOT/SUMMARY FILE(Y/N)?  ')
	  READ(*,50,ERR=895)FILEA2
	   IF(FILEA2.EQ.'N')GO TO 900
	   IF(FILEA2.NE.'Y')GO TO 895
C
C    WANT TO SAVE THESE RESULTS
C
	IF(INDICC)WRITE(2,897)HOUR,SK,ELO,EUP,A
	IF(.NOT.INDICC)WRITE(2,898)HOUR,SK,A
897	  FORMAT(7X,I4,9X,F12.2,4X,F12.2,7X,F12.2,8X,F7.2)
898	  FORMAT(7X,I4,9X,F12.2,43X,F7.2)
C ********************************************************************
C--
C--
C  MODIFICATIONS OF DATA
C--
900	write(*,901)
901	FORMAT('  WOULD YOU LIKE TO CONTINUE (Y/N)?  ')
	READ(*,50,ERR=900)FLAG
	IF( FLAG .EQ.'N')  GO TO 999
	IF(FLAG.NE.'Y') GO TO 900
C
C  IF ANALYZE SAME EXPERIMENT AT DIFFERENT DURATIONS, CAN CHANGE:
C	DURATION, MORTALITIES, AND TRIM (IF NOT AUTOMATIC).
C  IF ANALYZE ANOTHER EXPERIMENT, START AT TOP, WITH CREATION OF NEW
C	PLOT/SUMMARY FILE.
C
910	write(*,915)
915	 FORMAT('  WOULD YOU LIKE TO ANALYZE THE SAME EXPERIMENT',
     1		' AT A DIFFERENT DURATION(Y/N)?  ')
	  READ(*,50,ERR=910)FLAG
C
	write(*,920)
920	  FORMAT(//)
C
	  IF(FLAG.EQ.'Y')GO TO 500
	  IF(FLAG.NE.'N')GO TO 910
C
C   FLAG=YES
C
	  IF(PLOTAN.EQ.'Y')CLOSE(UNIT=2)
	  GO TO 150
C
C
C	*	*	*	*	*	*	*	*	*
980	AMINP=AMIN*100.
	WRITE ( *,985) AMINP                       
985	FORMAT ('   MINIMUM REQUIRED TRIM IS TOO LARGE: ',F5.1,               
     1			',SO SK IS NOT CALCULABLE.')
	AMIN=0.0
	GO TO 900
999	CONTINUE
	STOP ' RUN COMPLETED'
      END     
C ***********************************************************************
C
C    SUBROUTINE MNTN(     )
C
C
C  M. HAMILTON * DEPT. OF MATH. * MONTANA STATE UNIVERSITY*BOZEMAN *    
C  SUBROUTINE TO ADJUST PROPORTIONS TO BE MONOTONE INCREASING   
C
C   K=NO. OF CONCENTRATIONS   
C   N(I)=NO. OF SUBJECTS AT CONCENTRATION I   
C   PT(I)=PROPORTION OF RESPONSE AT CONCENTRATION I; ENTERS AS OBSERVED   
C        PROPORTION AND RETURNS AS ADJUSTED PROPORTION   
C ***********************************************************************
C
C
      SUBROUTINE MNTN(K,N, PT)   
C
C
      IMPLICIT REAL*8 (A-H,O-Z)      
	implicit integer*2 (i-n)
      DIMENSION N(10),PT(10)   
50    CONTINUE   
      NS=0   
      I=0     
100	CONTINUE           
      I=I+1    
      DD=PT(I+1)-PT(I)        
      IF(DD .GT. -1.0D-8) GO TO 500                 
      KA = I           
      IF (I .EQ. 1) GO TO 250                    
      J=I+1                  
150	CONTINUE                   
      J=J-1           
      IF(DABS(PT(J)-PT(J-1)) .GT. 1.0D-8) GO TO 250            
      KA=J-1         
      IF (J .LE. 2) GO TO 200                            
      GO TO 150                   
200	CONTINUE                   
250	KB=I+1                       
      IF(I .EQ.(K-1)) GO TO 350                   
      I1=I+1            
      K1=K-1          
      DO 300 J=I1,K1               
      DD=PT(J+1)-PT(J)    
      IF(DD .LT. 1.0D-8) GO TO 300         
      KB = J         
      GO TO 350                          
300     CONTINUE                                     
350     CONTINUE                               
      NCUM=0       
      CUM=0.0D0    
      DO 400 J=KA,KB                  
      CUM = CUM + PT(J)*N(J)      
400     NCUM = NCUM + N(J)                 
      DO 450 J=KA,KB                           
450	PT(J)=CUM/NCUM                    
      I=KB             
      NS=1            
500	IF (I .LE. (K-2)) GO TO 100           
      IF (NS .GT. 0) GO TO 50                       
      RETURN         
      END        
C ********************************************************************
C
C
C     SUBROUTINE SKA (    )
C
C
C     M. HAMILTON * DEPT. OF MATH. * MONTANA STATE UNIVERSITY * BOZEMAN *   
C     SUBROUTINE SKA CALCULATES THE 100*A PERCENT TRIMMED SPEARMAN-   
C    KARBER ESTIMATE OF THE MEDIAN OF THE TOLERANCE DISTRIBUTION.   
C    IT IS ASSUMED THAT THE TOLERANCE DISTRIBUTION IS SYMMETRIC.   
C    100*A PERCENT ARE TRIMMED FROM EACH TAIL.   
C    THE EST. VARIANCE OF THE ESTIMATE IS CALCULATED (VARSKA)   
C    K=NO. OF CONCENTRATIONS   
C    Z(I)=CONCENTRATION LEVEL I, ENTERED IN INCREASING ORDER   
C    N(I)=NUMBER OF SUBJECTS AT CONCENTRATION Z(I)   
C    PT(I)=PROPORTION OF RESPONSE AT CONCENTRATION Z(I); NONDECREASING    
C	IN I
C    PT=P-TILDA OF E,S, & T (1977) PAPER   
C      CALLS SUBROUTINE SK(   )   
C ********************************************************************   
C
      SUBROUTINE SKA(SKAEST,VARSKA,A,K,Z,N,PT,INDICC)      
C
      IMPLICIT REAL*8 (A-H,O-Z)   
	implicit integer*2 (i-n)
	LOGICAL*1 INDICC
      DIMENSION   P(10),Z(10),      N(10),PT(10)   
	INDICC=.TRUE.
C
C	*	*	*	*	*	*	*	*	*
C
C   NOTE:  THIS SUBROUTINE CONTAINS A FEW CHECKS.  IF AN ERROR IS
C	    SPOTTED, AN ERROR MESSAGE IS GIVEN AND THE PROGRAM STOPS.
C	    HOWEVER, WITH THE MODIFICATIONS IN THE MAIN PROGRAM, 
C	    THESE ERRORS SHOULD NEVER BE ENCOUNTERED AT THIS POINT
C	    IN THE PROGRAM.
C
C        CHECK FOR CALCULABILITY   
C     DETERMINE IF TRIM IS LARGE ENOUGH   
	DIF=PT(1)-A
      IF (PT(1) .LT. (1.D0-PT(K)))      DIF=1.D0-A-PT(K)   
      IF (DIF .GT. 0.0D0) GO TO 900   
C
C     FOR A=0.5, WHEN ONE OR MORE OF PT(I)=0.5,   
C     SKAEST=MEAN OF ASSOCIATED CONCENTRATIONS   
C     VARSKA IS NOT CALCULATED AND IS SET TO ZERO   
C      INDICC IS SET EQUAL TO FALSE
      IF (DABS(A-0.5D0) .GT. 1.0D-8) GO TO 200   
      ZMU=0.0D0   
      NW=0   
      DO 100 I=1,K   
        IW=1   
        IF (DABS(PT(I)-A) .GT. 1.0D-8) IW=0   
        ZMU=ZMU+Z(I)*IW   
100	NW=NW+IW   
      IF (NW .EQ. 0) GO TO 200   
      SKAEST=ZMU/NW   
      VARSKA=0.0D0   
	INDICC=.FALSE.
      RETURN   
C
C
C   FIND MAX(I SUCH THAT PT(I) .LE. A)
C
200	CONTINUE 
         I=K-1   
250	CONTINUE    
      DD = A-PT(I)      
      IF( (DD.GT. -1.0D-8) .AND. (PT(I+1) .GT. A))  GO TO 300    
      I=I-1     
      IF (I .LT. 1) GO TO  900   
      GO TO 250    
300	JLT=I   
C   JLT=MAX(I SUCH THAT PT(I) .LE. A)   
C
C
C   WHEN A = 0.5, VARSKA IS NOT CALCULATED AND IS SET TO ZERO;    
C	INDICC IS SET TO .FALSE.
C
      IF(DABS(A-0.5D0) .GT. 1.0D-8) GO TO 400              
C
C     IF A = .50 AND  NO P(I) = .5 :
      SKAEST=Z(JLT)+(Z(JLT+1)-Z(JLT))*(A-PT(JLT))/(PT(JLT+1)-PT(JLT))    
      VARSKA=0.0       
	INDICC=.FALSE.
      RETURN       
C
400	CONTINUE   
C
C
C   FIND MIN(I SUCH THAT P(I) .GE. 1-A)
C
      DO 500 I=2,K   
        KOUNT = I             
        DD = PT(I) - (1.D0-A)     
        IF((PT(I-1) .LT. (1.D0-A) ) .AND. (DD .GT. -1.D-8)) GO TO 600      
500	CONTINUE   
      GO TO 900   
600	JUT=KOUNT   
C   JUT=MIN(I SUCH THAT P(I) .GE. 1-A)         
C
      IF(JLT .EQ. JUT) GO TO 900         
C	*	*	*	*	*	*	*	*	*
C
C   CALL SUBROUTINE SK( )   
      CALL SK(SKAEST,VARSKA,Z,N,PT,A,JLT,JUT,INDICC)              
      RETURN            
900	write(*,*)'  ERROR.'
	STOP
      END         
C
C *******************************************************************
C
C     SUBROUTINE SK(     )
C
C
C   M. HAMILTON * DEPT. OF MATH. * MONTANA STATE UNIVERSITY*BOZEMAN *   
C   SUBROUTINE SK CALCULATES THE 100A% TRIMMED SPEARMAN-KARBER    
C   ESTIMATE AND THE ESTIMATED VARIANCE OF THE ESTIMATE        
C *******************************************************************
C
C   
      SUBROUTINE SK(SKEST,VARSK,Z,N,PT,A,KLT,KUT,INDICC)   
C
      IMPLICIT REAL*8 (A-H,O-Z)         
	implicit integer*2 (i-n)
      DIMENSION Z(10),N(10),PT(10)      
	LOGICAL*1 INDICC
      IF (KLT .EQ. (KUT-1)) GO TO 400                   
      IF (KLT .EQ. (KUT-2)) GO TO 500                  
C...CALCULATIONS FOR (KUT-KLT) .GE. 3  (MORE THAN THREE CONCENTRATIONS     
C	LEFT AFTER TRIMMING)
C
C  SPEARMAN-KARBER ESTIMATE
      Y1=(Z(KLT+1)-Z(KLT))*(A-PT(KLT))*(PT(KLT+1)-A)   
      Y1=Y1/(2.D0*(PT(KLT+1)-PT(KLT)))                     
      Y2=(Z(KLT)+Z(KLT+1))*(PT(KLT+1)-A)/2.D0     
      Y4=(Z(KUT-1)+Z(KUT))*(1.D0-A-PT(KUT-1))/2.D0      
      Y5=(Z(KUT)-Z(KUT-1))*(1.D0-A-PT(KUT-1))*(PT(KUT)-1.D0+A)    
      Y5=Y5/(2.D0*(PT(KUT-1)-PT(KUT)))         
      Y3=0.D0              
      KLT1=KLT+1     
      KUT2=KUT-2   
      DO 100 I=KLT1,KUT2                                       
100	Y3=Y3+(Z(I)+Z(I+1))*(PT(I+1)-PT(I))/2.D0        
      SKEST=(Y1+Y2+Y3+Y4+Y5)/(1.D0-2.D0*A)            
C  VARIANCE ESTIMATE
      V1=(Z(KLT+1)-Z(KLT))*(((PT(KLT+1)-A)/(PT(KLT+1)-PT(KLT)))**2)      
      V1=(V1**2)*PT(KLT)*(1.D0-PT(KLT))/(N(KLT)*4.D0)     
      V2=(Z(KLT+1)-Z(KLT))*(((A-PT(KLT))/(PT(KLT+1)-PT(KLT)))**2)     
      V2=Z(KLT)-Z(KLT+2)+V2                 
      V2=(V2**2)*PT(KLT+1)*(1.D0-PT(KLT+1))/(N(KLT+1)*4.D0)      
      V4=(Z(KUT)-Z(KUT-1))*(((PT(KUT)-1.D0+A)/(PT(KUT)-PT(KUT-1)))**2)   
      V4=Z(KUT-2)-Z(KUT)+V4             
      V4=(V4**2)*PT(KUT-1)*(1.D0-PT(KUT-1))/(N(KUT-1)*4.D0)     
      V5=(Z(KUT)-Z(KUT-1))*(((1.D0-A-PT(KUT-1))/(PT(KUT)-PT(KUT-1)))**2)   
      V5=(V5**2)*PT(KUT)*(1.D0-PT(KUT))/(N(KUT)*4.D0)         
      V3=0.D0    
      IF (KUT .EQ. (KLT+3)) GO TO 300                      
      KLT2=KLT+2     
      KUT2=KUT-2    
      DO 200 I=KLT2,KUT2                              
200     V3=V3+((Z(I+1)-Z(I-1))**2)*PT(I)*(1.D0-PT(I))/(4.D0*N(I))    
300     VARSK=(V1+V2+V3+V4+V5)/((1.D0-2.D0*A)**2)              
      GO TO 900                                
C...CALCULATIONS FOR (KUT-KLT) .EQ. 1                
400     CONTINUE                                   
      SKEST=Z(KLT)+(0.5D0-PT(KLT))*(Z(KUT)-Z(KLT))/(PT(KUT)-PT(KLT))     
      V1=((1.D0-2.D0*PT(KUT))**2)*PT(KLT)*(1.D0-PT(KLT))/N(KLT)       
      V2=((1.D0-2.D0*PT(KLT))**2)*PT(KUT)*(1.D0-PT(KUT))/N(KUT)      
      V3=((Z(KUT)-Z(KLT))/(2.D0*(PT(KUT)-PT(KLT))**2))**2      
      VARSK=V3*(V1+V2)          
C *** WARNING ***            
C                IF PT(KLT)=0.0 &/OR PT(KUT)=1.0 THEN            
C                VARSK IMMEDIATELY ABOVE IS INAPPROPRIATE       
	IF((DABS(PT(KLT)).LE.1.0D-8).OR.(DABS(1.0D0-PT(KUT)).
     1                 LE.1.0D-8))INDICC=.FALSE.
      GO TO 900                              
C...CALCULATIONS FOR (KUT-KLT) .EQ. 2      
500     Y1=(A-PT(KLT))*(PT(KLT+1)-A)*(Z(KLT+1)-Z(KLT))    
      Y1=Y1/(2.D0*(PT(KLT+1)-PT(KLT)))              
      Y2=(Z(KLT)+Z(KLT+1))*(PT(KLT+1)-A)/2.D0       
      Y3=(Z(KLT+1)+Z(KLT+2))*(1.D0-A-PT(KLT+1))/2.D0      
      Y4=(1.D0-A-PT(KLT+1))*(PT(KLT+2)-1.D0+A)*(Z(KLT+1)-Z(KLT+2))     
      Y4=Y4/(2.D0*(PT(KLT+2)-PT(KLT+1)))      
      SKEST=(Y1+Y2+Y3+Y4)/(1.D0-2.D0*A)     
      V1=(Z(KLT+1)-Z(KLT))*(((PT(KLT+1)-A)/(PT(KLT+1)-PT(KLT)))**2)    
      V1=(V1**2)*PT(KLT)*(1.D0-PT(KLT))/(4.D0*N(KLT))      
      V2=(Z(KLT)-Z(KUT))/2.D0   
      VV=(Z(KUT)-Z(KLT+1))/2.D0      
      V2=V2+VV*(((PT(KLT+2)-1.D0+A)/(PT(KLT+2)-PT(KLT+1)))**2)        
      VV=(Z(KLT+1)-Z(KLT))/2.D0                 
      V2=V2-VV*(((A-PT(KLT))/(PT(KLT+1)-PT(KLT)))**2)    
      V2=(V2**2)*PT(KLT+1)*(1.D0-PT(KLT+1))/N(KLT+1)    
      V3=(Z(KUT)-Z(KLT+1))*(((1.D0-A-PT(KLT+1))/(PT(KUT)-PT(KLT+1)))**2)   
       V3=(V3**2)*PT(KUT)*(1.D0-PT(KUT))/(4.D0*N(KUT))    
      VARSK=(V1+V2+V3)/((1.D0-2.D0*A)**2)   
900     RETURN                                          
      END
