@ECHO OFF
CLS
GOTO START
REM  ******************* \LC50\SPEARMAN.BAT **********************
REM  *       Author: D.W. Disney, Senior Systems Analyst         *
REM  *               OAO Corporation                             *
REM  *         Date: Friday, 8 January 1999.  Time: 10:15:22.    *
REM  *  Environment: Dell OptiPlex Gn+ under MS DOS window (W95) *
REM  * Installation: OAO Corporation                             *
REM  *               U.S. Environmental Protection Agency        *
REM  *               NERL - Ecosystems Research Div., Athens, GA *
REM  *     Function: Execute SPEARMAN model via DOS command line *
REM  *     Calling                                               *
REM  *     Sequence: SPEARMAN [filename] where filename is the   *
REM  *               name of an optional input, screen prompt,   *
REM  *               response file.                              *
REM  *        Input: Command line: [filename]                    *
REM  *                      Other: run time prompts              *
REM  *************************************************************
REM  ----- Label START ------------------------------------------------------
:START
IF "%1"=="DEBUG" GOTO CHECKEXE
IF "%1"=="debug" GOTO CHECKEXE
IF EXIST C:\00\LC50\XLC50X.EXE GOTO RUNLC501
GOTO ERROREXE
REM  ----- Label CHECKEXE ---------------------------------------------------
:CHECKEXE
IF EXIST \LC50\XLC50X.EXE GOTO RUNLC501
REM  ----- Label ERROREXE ---------------------------------------------------
:ERROREXE
ECHO #
ECHO # ----------------------------------------------------------------------
ECHO #
ECHO ##  ERROR:  BAD OR MISSING XLC50X.EXE FILE
ECHO #
ECHO #           The LC50 executable task image file XLC50X.EXE is
ECHO #           not located in DOS sub-directory C:\00\LC50.
ECHO #
ECHO #           Install and/or copy this file and all of its support
ECHO #           files to sub-directory C:\00\LC50 or contact
ECHO #           CEAM (ceam@epamail.epa.gov) for assistance.
ECHO #
ECHO #   Press "<Enter>" key to return to DOS command prompt.
PAUSE >NUL
GOTO STOP
REM  ----- Label RUNLC501 ---------------------------------------------------
:RUNLC501
IF "%1"=="DEBUG" TYPE \LC50\LC50OPEN.SCR
IF "%1"=="debug" TYPE \LC50\LC50OPEN.SCR
IF "%1"=="DEBUG" PAUSE >NUL
IF "%1"=="debug" PAUSE >NUL
IF "%1"=="DEBUG" GOTO TYPESCR
IF "%1"=="debug" GOTO TYPESCR
TYPE C:\00\LC50\LC50OPEN.SCR
PAUSE >NUL
REM  ----- Label TYPESCR ----------------------------------------------------
:TYPESCR
CLS
ECHO #
ECHO #----------------------------------------------------------------------#
ECHO ##  Executing SPEARMAN DOS command file.
ECHO #----------------------------------------------------------------------#
ECHO #
ECHO #
ECHO ##  Loading LC50 model task image file...wait.
REM
IF "%1"=="DEBUG" SET LFDIR=C:\F77L3\BIN\
IF "%1"=="debug" SET LFDIR=C:\F77L3\BIN\
IF "%1"=="DEBUG" GOTO RUN_LC50
IF "%1"=="debug" GOTO RUN_LC50
SET LFDIR=C:\00\LC50
REM  ----- Label RUN_LC50 ---------------------------------------------------
:RUN_LC50
IF "%1"=="DEBUG" \LC50\XLC50X
IF "%1"=="debug" \LC50\XLC50X
IF "%1"=="DEBUG" GOTO ENDRUN
IF "%1"=="debug" GOTO ENDRUN
ECHO #
ECHO #------------------------#
ECHO ##  LC50 run beginning.
ECHO #------------------------#
ECHO #
ECHO #                                    >>LC50_RUN.LOG
ECHO # ----- RUN DATE/TIME STAMP ----- #  >>LC50_RUN.LOG
ECHO # ----- Begin Execution     ----- #  >>LC50_RUN.LOG
IF NOT "%1"=="" ECHO #                    >>LC50_RUN.LOG
IF NOT "%1"=="" ECHO # ----- Data set: %1 >>LC50_RUN.LOG
ECHO #                                    >>LC50_RUN.LOG
DATE <C:\00\LC50\RETURN1.ANS | FIND "C" >>LC50_RUN.LOG
TIME <C:\00\LC50\RETURN1.ANS | FIND "C" >>LC50_RUN.LOG
ECHO #                                    >>LC50_RUN.LOG
REM CLS
IF "%1"=="" GOTO NOINFILE
C:\00\LC50\XLC50X <%1
GOTO ENDEXE
:NOINFILE
C:\00\LC50\XLC50X
:ENDEXE
ECHO #                                   >>LC50_RUN.LOG
ECHO # ----- End Execution       ----- # >>LC50_RUN.LOG
ECHO #                                   >>LC50_RUN.LOG
DATE <C:\00\LC50\RETURN1.ANS | FIND "C" >>LC50_RUN.LOG
TIME <C:\00\LC50\RETURN1.ANS | FIND "C" >>LC50_RUN.LOG
ECHO #                                   >>LC50_RUN.LOG
ECHO # --------------------------------------------------- # >>LC50_RUN.LOG
REM
REM  ----- Label ENDRUN -----------------------------------------------------   
:ENDRUN
SET LFDIR=
ECHO.
ECHO ##  LC50 program execution complete.
IF "%1"=="DEBUG" ECHO #   Press "<Enter>" key to return to DOS command prompt.
IF "%1"=="debug" ECHO #   Press "<Enter>" key to return to DOS command prompt.
IF "%1"=="DEBUG" PAUSE >NUL
IF "%1"=="debug" PAUSE >NUL
GOTO FINISH
REM  ----- Label STOP -------------------------------------------------------   
:STOP
ECHO.
IF "%1"=="DEBUG" GOTO FINISH
IF "%1"=="debug" GOTO FINISH
CLS
REM  ----- Label FINISH -----------------------------------------------------   
:FINISH
