#!/bin/sh
# test.sh -- run annie test data sets
#
# Usage: test.sh [start [stop]]
#
#        where: start = starting test number
#                stop = ending test number (may be same as start)
#
# History: 96/04/17 kmflynn

# pathname
WrdA=/usr/opt/wrdapp

#*******************************************************************
#***** You should not need to modify anything below this line. *****
#*******************************************************************

  Prgm=$WrdA/annie2.2
  Data=$WrdA/annie2.2/data
  Chck=$WrdA/annie2.2/test

  exec 2>&1                                # stderr shows up in .out file
  Start=${1-1}                             # by default, start at 1
  Stop=${2-3}                              # by default, stop at 2
                                           # 1 - create wdm, import data
                                           # 2 - table attributes
                                           # 3 - generate and archive
#
# begin test runs
  echo
  echo _________________________________________________________________
  echo " Processing annie test runs $Start to $Stop"
  echo " annie program from: $Prgm"
  echo "     test data from: $Data"
  echo `date`

  if [ $Start -eq 1 ] ; then
#    remove old files
     if [ -f test.wdm ] ; then rm test.wdm ; fi
     if [ -f cane.exp ] ; then rm cane.exp ; fi
     if [ -f il.exp ]   ; then rm il.exp   ; fi
#    link in input files
     ln -s $Data/cane.exp cane.exp
     ln -s $Data/il.exp il.exp
  fi

  Test=$Start
  while [ $Test -ge $Start -a $Test -le $Stop ] ; do
#    each requested test run
     echo
     echo
     echo _________________________________________________________________
     echo "Test run number $Test"
     echo
     for Fils in ANNIE.LOG ERROR.FIL test$Test.out test$Test.exp ; do
#       remove old files
        if [ -f $Fils ] ; then rm $Fils ; fi
     done

     $Prgm/bin/annie <<-EOT
	@$Data/test$Test.log
	EOT

#    remove unneeded files
     rm ANNIE.LOG ERROR.FIL

     Test=`expr $Test + 1`
  done
#

  if [ $Start -eq 1 ] ; then
#    remove input files
     rm cane.exp
     rm il.exp
  fi

  echo
  echo
  echo _________________________________________________________________
  echo "Completed ANNIE test runs $Start to $Stop"
  echo
# check output against original output in $Data directory
  $Chck/check.sh $Data

# end of test shell
