#!/bin/sh
# graph.sh -- run annie graphics tests
#
# Usage: graph.sh [start [stop]]
#
#        where: start = starting test number
#                stop = ending test number (may be same as start)
#
# History: 95/08/21 kmflynn
#
# pathname
WrdA=/usr/opt/wrdapp

# version of gks being used, set Gks to
#        Xgks - if using Xgks library for graphics
#        PriorGks - if using Prior Gks library for graphics
    Xgks=x
PriorGks=
     Gks=$PriorGks

#*******************************************************************
#***** You should not need to modify anything below this line. *****
#*******************************************************************

  Prgm=$WrdA/annie2.2
  Data=$WrdA/annie2.2/data
  Chck=$WrdA/annie2.2/test

  exec 2>&1                               # stderr shows up in .out file

  Start=${1-1}                            # by default, start at 1
  Stop=${2-6}                             # by default, stop at 6
                                          # 1 - hydrograph, 3 axes
                                          # 2 - hydrograph, 2 axes
                                          # 3 - x-y plot
                                          # 4 - x-y plot
                                          # 5 - atribute plot, p100 vs darea
                                          # 6 - attribute, p100 & p1.25 vs darea
#
# begin test runs
  echo
  echo _________________________________________________________________
  echo " Processing annie graphics tests $Start to $Stop"
  echo " annie program from $Prgm"
  echo " test data from $Data"
  echo
  date

# make sure the wdm file is available
  if [ -f test.wdm ]
     then
         echo " Using the test.wdm file that is in the directory"
     else
         echo " copying test.wdm from $Data"
         cp -p $Data/test.wdm .
  fi

  Test=$Start
  while [ $Test -ge $Start -a $Test -le $Stop ]
  do
#   each requested test run
    echo
    echo
    echo _________________________________________________________________
    echo "Test run number $Test"
    echo
    for Fils in ANNIE.LOG ERROR.FIL graph$Gks$Test.ps ; do
       if [ -f $Fils ] ; then rm $Fils ; fi
    done

    $Prgm/bin/annie <<-EOT
	@$Data/graph$Gks$Test.log
	EOT

    Test=`expr $Test + 1`
  done
#
  echo
  echo
  echo _________________________________________________________________
  echo "Completed ANNIE test runs $Start to $Stop"
  echo
# check output against original output in ../data directory
  $Chck/check.sh $Data graph$Gks

# end of test shell
