#!/bin/sh
#  wdimex.sh -- make anmess.wdm for annie
#
# History  95/12/08 kmflynn
#
# Usage: wdimex.sh | tee wdimex.out
#
# pathname
  WrdA=/usr/opt/wrdapp

#*******************************************************************
#***** You should not need to modify anything below this line. *****
#*******************************************************************


# pathnames and file names
  Libr=$WrdA/lib3.0
  Name=anmess
  Seqs='annie'
  SeqL='ann/atwork   ann/atdisp   ann/dswork   ann/dsbld    ann/qtdate
        ann/prwarc   ann/wdplot   ann/tswork   ann/pgener   ann/qtprnt
        waide/agplot waide/tbltmp waide/tslist waide/tstabl'

  echo
  echo '     Library =' $Libr
  echo '    wdm name =' $Name.wdm
  echo ' sequentials =' $Seqs
  echo '              ' $SeqL
  echo

# remove any old files
  if [ -f $Name.wdm ] ; then rm $Name.wdm ; fi
  if [ -f error.fil ] ; then rm error.fil ; fi
  if [ -f wdimex.in ] ; then rm wdimex.in ; fi

# build input file
  echo $Name.wdm > wdimex.in
  for Seq in $Seqs ; do
     echo I >> wdimex.in
     echo $Seq.seq >> wdimex.in
  done
  for Seq in $SeqL ; do
     echo I >> wdimex.in
     echo $Libr/msg/$Seq.seq >> wdimex.in
  done
  echo R >> wdimex.in

#
# get message file shell
  cp $Libr/lib_data/message.wdm $Name.wdm

# build message file
  $Libr/bin/wdimex < wdimex.in

# remove old message file and move new one into bin
  if [ -f ../bin_data/$Name.wdm ] ; then rm ../bin_data/$Name.wdm ; fi
  mv $Name.wdm ../bin_data

# end of shell
