C
C
C
      SUBROUTINE   HARTIV
     I                    (SKU,
     O                     PD)
C
C     + + + PURPOSE + + +
C     This routine looks up percentage points of the standardized
C     Pearson Type III distribution with shew coefficient SKEW in
C     Harter's (1969,1971) tables.  Interpolation is done on the skew
C     coefficient at all 31 tabular probabilities considered in
C     Harter's two papers.  The resultant interpolated percentage
C     ponits are placed in the 31-word vector RIPS in increasing order.
C     Skew must not exceed 9.0.
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   SKU, PD(31)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     SKU    - skew coefficient
C     PD     - percentage points (31 values)
C
C     + + + SAVE VARIABLES + + +
      SAVE  VM1,V 0,V 1,V 2,V 3,V 4,V 5,V 6,V 7,V 8,V 9,V10,
     #  V11,V12,V13,V14,V15,V16,V17,V18,V19,V20,V21,V22,
     #  V23,V24,V25,V26,V27,V28,V29,V30,V31,V32,V33,V34,
     #  V35,V36,V37,V38,V39,V40,V41,V42,V43,V44,V45,V46,
     #  V47,V48,V50,V52,V54,V56,V58,V60,
     #  V62,V64,V66,V68,V70,V72,V74,V76,V78,V80,V82,V84,
     #  V86,V88,V90
      REAL
     #  VM1(31),  V 0(31),  V 1(31),  V 2(31),  V 3(31),  V 4(31),
     #  V 5(31),  V 6(31),  V 7(31),  V 8(31),  V 9(31),  V10(31),
     #  V11(31),  V12(31),  V13(31),  V14(31),  V15(31),  V16(31),
     #  V17(31),  V18(31),  V19(31),  V20(31),  V21(31),  V22(31),
     #  V23(31),  V24(31),  V25(31),  V26(31),  V27(31),  V28(31),
     #  V29(31),  V30(31),  V31(31),  V32(31),  V33(31),  V34(31),
     #  V35(31),  V36(31),  V37(31),  V38(31),  V39(31),  V40(31),
     #  V41(31),  V42(31),  V43(31),  V44(31),  V45(31),  V46(31),
     #  V47(31),  V48(31)
      REAL
     #  V50(31),  V52(31),  V54(31),  V56(31),  V58(31),  V60(31),
     #  V62(31),  V64(31),  V66(31),  V68(31),  V70(31),  V72(31),
     #  V74(31),  V76(31),  V78(31),  V80(31),  V82(31),  V84(31),
     #  V86(31),  V88(31),  V90(31)

C     + + + LOCAL VARIABLES + + +
      INTEGER   IORDER, L, I, KKTV
      REAL   PCT(31,71), C0, C1, C2, H, P, Q, R, S, SKTV
C
C     + + + EQUIVALENCES + + +
      EQUIVALENCE
     #  (VM1(1),PCT(1, 1)),  (V 0(1),PCT(1, 2)),  (V 1(1),PCT(1, 3)),
     #  (V 2(1),PCT(1, 4)),  (V 3(1),PCT(1, 5)),  (V 4(1),PCT(1, 6)),
     #  (V 5(1),PCT(1, 7)),  (V 6(1),PCT(1, 8)),  (V 7(1),PCT(1, 9)),
     #  (V 8(1),PCT(1,10)),  (V 9(1),PCT(1,11)),  (V10(1),PCT(1,12)),
     #  (V11(1),PCT(1,13)),  (V12(1),PCT(1,14)),  (V13(1),PCT(1,15)),
     #  (V14(1),PCT(1,16)),  (V15(1),PCT(1,17)),  (V16(1),PCT(1,18)),
     #  (V17(1),PCT(1,19)),  (V18(1),PCT(1,20)),  (V19(1),PCT(1,21)),
     #  (V20(1),PCT(1,22)),  (V21(1),PCT(1,23)),  (V22(1),PCT(1,24)),
     #  (V23(1),PCT(1,25)),  (V24(1),PCT(1,26)),  (V25(1),PCT(1,27)),
     #  (V26(1),PCT(1,28)),  (V27(1),PCT(1,29)),  (V28(1),PCT(1,30)),
     #  (V29(1),PCT(1,31)),  (V30(1),PCT(1,32)),  (V31(1),PCT(1,33)),
     #  (V32(1),PCT(1,34)),  (V33(1),PCT(1,35)),  (V34(1),PCT(1,36)),
     #  (V35(1),PCT(1,37)),  (V36(1),PCT(1,38)),  (V37(1),PCT(1,39)),
     #  (V38(1),PCT(1,40)),  (V39(1),PCT(1,41)),  (V40(1),PCT(1,42)),
     #  (V41(1),PCT(1,43)),  (V42(1),PCT(1,44)),  (V43(1),PCT(1,45)),
     #  (V44(1),PCT(1,46)),  (V45(1),PCT(1,47)),  (V46(1),PCT(1,48)),
     #  (V47(1),PCT(1,49)),  (V48(1),PCT(1,50))
C
      EQUIVALENCE
     #  (V50(1),PCT(1,51)),  (V52(1),PCT(1,52)),  (V54(1),PCT(1,53)),
     #  (V56(1),PCT(1,54)),  (V58(1),PCT(1,55)),  (V60(1),PCT(1,56)),
     #  (V62(1),PCT(1,57)),  (V64(1),PCT(1,58)),  (V66(1),PCT(1,59)),
     #  (V68(1),PCT(1,60)),  (V70(1),PCT(1,61)),  (V72(1),PCT(1,62)),
     #  (V74(1),PCT(1,63)),  (V76(1),PCT(1,64)),  (V78(1),PCT(1,65)),
     #  (V80(1),PCT(1,66)),  (V82(1),PCT(1,67)),  (V84(1),PCT(1,68)),
     #  (V86(1),PCT(1,69)),  (V88(1),PCT(1,70)),  (V90(1),PCT(1,71))
C
C     + + + INTRINSICS + + +
      INTRINSIC   ABS, FLOAT
C
C     + + + DATA INITIALIZATIONS + + +
      DATA  VM1  /
     #    -3.93453,    -3.45513,    -3.23322,    -2.99978,
     #    -2.66965,    -2.39961,    -2.10697,    -2.00688,
     #    -1.78462,    -1.67279,    -1.29178,    -0.83639,
     #    -0.51207,    -0.23763,    -0.16111,     0.01662,
     #     0.19339,     0.26882,     0.53624,     0.84611,
     #     1.27037,     1.61594,     1.71580,     1.91219,
     #     1.99973,     2.25258,     2.48187,     2.75706,
     #     2.94834,     3.12767,     3.50703    /
C
      DATA V0 /   -3.71902,
     #  -3.29053, -3.09023, -2.87816, -2.57583, -2.32635, -2.05375,
     #  -1.95996, -1.75069, -1.64485, -1.28155, -0.84162, -0.52440,
     #  -0.25335, -0.17733,  0.0    ,  0.17733,  0.25335,  0.52440,
     #   0.84162,  1.28155,  1.64485,  1.75069,  1.95996,  2.05375,
     #   2.32635,  2.57583,  2.87816,  3.09023,  3.29053,  3.71902 /
      DATA V1 /    -3.50703,
     #  -3.12767, -2.94834, -2.75706, -2.48187, -2.25258, -1.99973,
     #  -1.91219, -1.71580, -1.61594, -1.27037, -0.84611, -0.53624,
     #  -0.26882, -0.19339, -0.01662,  0.16111,  0.23763,  0.51207,
     #   0.83639,  1.29178,  1.67279,  1.78462,  2.00688,  2.10697,
     #   2.39961,  2.66965,  2.99978,  3.23322,  3.45513,  3.93453 /
      DATA V2 /   -3.29921,
     #  -2.96698, -2.80786, -2.63672, -2.38795, -2.17840, -1.94499,
     #  -1.86360, -1.67999, -1.58607, -1.25824, -0.84986, -0.54757,
     #  -0.28403, -0.20925, -0.03325,  0.14472,  0.22168,  0.49927,
     #   0.83044,  1.30105,  1.69971,  1.81756,  2.05290,  2.15935,
     #   2.47226,  2.76321,  3.12169,  3.37703,  3.62113,  4.15301 /
      DATA V3 /   -3.09631,
     #  -2.80889, -2.66915, -2.51741, -2.29423, -2.10394, -1.88959,
     #  -1.81427, -1.64329, -1.55527, -1.24516, -0.85285, -0.55839,
     #  -0.29897, -0.22492, -0.04993,  0.12820,  0.20552,  0.48600,
     #   0.82377,  1.30936,  1.72562,  1.84949,  2.09795,  2.21081,
     #   2.54421,  2.85636,  3.24371,  3.52139,  3.78820,  4.37394 /
      DATA V4 /   -2.89907,
     #  -2.65390, -2.53261, -2.39942, -2.20092, -2.02933, -1.83361,
     #  -1.76427, -1.60574, -1.52357, -1.23114, -0.85508, -0.56867,
     #  -0.31362, -0.24037, -0.06651,  0.11154,  0.18916,  0.47228,
     #   0.81638,  1.31671,  1.75048,  1.88039,  2.14202,  2.26133,
     #   2.61539,  2.94900,  3.36566,  3.66608,  3.95605,  4.59687 /
      DATA V5 /   -2.70836,
     #  -2.50257, -2.39867, -2.28311, -2.10825, -1.95472, -1.77716,
     #  -1.71366, -1.56740, -1.49101, -1.21618, -0.85653, -0.57840,
     #  -0.32796, -0.25558, -0.08302,  0.09478,  0.17261,  0.45812,
     #   0.80829,  1.32309,  1.77428,  1.91022,  2.18505,  2.31084,
     #   2.68572,  3.04102,  3.48737,  3.81090,  4.12443,  4.82141 /
      DATA V6 /   -2.52507,
     #  -2.35549, -2.26780, -2.16884, -2.01644, -1.88029, -1.72033,
     #  -1.66253, -1.52830, -1.45762, -1.20028, -0.85718, -0.58757,
     #  -0.34198, -0.27047, -0.09945,  0.07791,  0.15589,  0.44352,
     #   0.79950,  1.32850,  1.79701,  1.93896,  2.22702,  2.35931,
     #   2.75514,  3.13232,  3.60872,  3.95567,  4.29311,  5.04718 /
      DATA V7 /   -2.35015,
     #  -2.21328, -2.14053, -2.05701, -1.92580, -1.80621, -1.66325,
     #  -1.61099, -1.48852, -1.42345, -1.18347, -0.85703, -0.59615,
     #  -0.35565, -0.28516, -0.11578,  0.06097,  0.13901,  0.42851,
     #   0.79002,  1.33294,  1.81864,  1.96660,  2.26790,  2.40670,
     #   2.82359,  3.22281,  3.72957,  4.10022,  4.46189,  5.27389 /
      DATA V8 /   -2.18448,
     #  -2.07661, -2.01739, -1.94806, -1.83660, -1.73271, -1.60604,
     #  -1.55914, -1.44813, -1.38855, -1.16574, -0.85607, -0.60412,
     #  -0.36889, -0.29961, -0.13199,  0.04397,  0.12199,  0.41309,
     #   0.77986,  1.33640,  1.83916,  1.99311,  2.30764,  2.45298,
     #   2.89101,  3.31243,  3.84981,  4.24439,  4.63057,  5.50124 /
      DATA V9 /   -2.02891,
     #  -1.94611, -1.89894, -1.84244, -1.74919, -1.66001, -1.54886,
     #  -1.50712, -1.40720, -1.35299, -1.14712, -0.85426, -0.61146,
     #  -0.38186, -0.31368, -0.14807,  0.02693,  0.10486,  0.39729,
     #   0.76902,  1.33889,  1.85856,  2.01848,  2.34623,  2.49811,
     #   2.95735,  3.40109,  3.96932,  4.38807,  4.79899,  5.72899 /
      DATA V10 /   -1.88410,
     #  -1.82241, -1.78572, -1.74062, -1.66390, -1.58838, -1.49188,
     #  -1.45507, -1.36584, -1.31684, -1.12762, -0.85161, -0.61815,
     #  -0.39434, -0.32740, -0.16397,  0.00987,  0.08763,  0.38111,
     #   0.75752,  1.34039,  1.87683,  2.04269,  2.38364,  2.54206,
     #   3.02256,  3.48874,  4.08802,  4.53112,  4.96701,  5.95691 /
      DATA V11 /   -1.75053,
     #  -1.70603, -1.67825, -1.64305, -1.58110, -1.51808, -1.43529,
     #  -1.40314, -1.32414, -1.28019, -1.10726, -0.84809, -0.62415,
     #  -0.40638, -0.34075, -0.17968, -0.00719,  0.07032,  0.36458,
     #   0.74537,  1.34092,  1.89395,  2.06573,  2.41984,  2.58480,
     #   3.08660,  3.57530,  4.20582,  4.67344,  5.13449,  6.18480 /
      DATA V12 /   -1.62838,
     #  -1.59738, -1.57695, -1.55016, -1.50114, -1.44942, -1.37929,
     #  -1.35153, -1.28225, -1.24313, -1.08608, -0.84369, -0.62944,
     #  -0.41794, -0.35370, -0.19517, -0.02421,  0.05297,  0.34772,
     #   0.73257,  1.34047,  1.90992,  2.08758,  2.45482,  2.62631,
     #   3.14944,  3.66073,  4.32263,  4.81492,  5.30130,  6.41249 /
      DATA V13 /   -1.51752,
     #  -1.49673, -1.48216, -1.46232, -1.42439, -1.38267, -1.32412,
     #  -1.30042, -1.24028, -1.20578, -1.06413, -0.83841, -0.63400,
     #  -0.42899, -0.36620, -0.21040, -0.04116,  0.03560,  0.33054,
     #   0.71915,  1.33904,  1.92472,  2.10823,  2.48855,  2.66657,
     #   3.21103,  3.74497,  4.43839,  4.95549,  5.46735,  6.63980 /
      DATA V14 /   -1.41753,
     #  -1.40413, -1.39408, -1.37981, -1.35114, -1.31815, -1.26999,
     #  -1.25004, -1.19842, -1.16827, -1.04144, -0.83223, -0.63779,
     #  -0.43949, -0.37824, -0.22535, -0.05803,  0.01824,  0.31307,
     #   0.70512,  1.33665,  1.93836,  2.12768,  2.52102,  2.70556,
     #   3.27134,  3.82798,  4.55304,  5.09505,  5.63252,  6.86661 /
      DATA V15 /   -1.32774,
     #  -1.31944, -1.31275, -1.30279, -1.28167, -1.25611, -1.21716,
     #  -1.20059, -1.15682, -1.13075, -1.01810, -0.82516, -0.64080,
     #  -0.44942, -0.38977, -0.23996, -0.07476,  0.00092,  0.29535,
     #   0.69050,  1.33330,  1.95083,  2.14591,  2.55222,  2.74325,
     #   3.33035,  3.90973,  4.66651,  5.23353,  5.79673,  7.09277 /
      DATA V16 /   -1.24728,
     #  -1.24235, -1.23805, -1.23132, -1.21618, -1.19680, -1.16584,
     #  -1.15229, -1.11566, -1.09338, -0.99418, -0.81720, -0.64300,
     #  -0.45873, -0.40075, -0.25422, -0.09132, -0.01631,  0.27740,
     #   0.67532,  1.32900,  1.96213,  2.16293,  2.58214,  2.77964,
     #   3.38804,  3.99016,  4.77875,  5.37087,  5.95990,  7.31818 /
      DATA V17 /   -1.17520,
     #  -1.17240, -1.16974, -1.16534, -1.15477, -1.14042, -1.11628,
     #  -1.10537, -1.07513, -1.05631, -0.96977, -0.80837, -0.64436,
     #  -0.46739, -0.41116, -0.26808, -0.10769, -0.03344,  0.25925,
     #   0.65959,  1.32376,  1.97227,  2.17873,  2.61076,  2.81472,
     #   3.44438,  4.06926,  4.88971,  5.50701,  6.12196,  7.54272 /
      DATA V18 /   -1.11054,
     #  -1.10901, -1.10743, -1.10465, -1.09749, -1.08711, -1.06864,
     #  -1.06001, -1.03543, -1.01973, -0.94496, -0.79868, -0.64488,
     #  -0.47538, -0.42095, -0.28150, -0.12381, -0.05040,  0.24094,
     #   0.64335,  1.31760,  1.98124,  2.19332,  2.63810,  2.84848,
     #   3.49935,  4.14700,  4.99937,  5.64190,  6.28285,  7.76632 /
      DATA V19 /   -1.05239,
     #  -1.05159, -1.05068, -1.04898, -1.04427, -1.03695, -1.02311,
     #  -1.01640, -0.99672, -0.98381, -0.91988, -0.78816, -0.64453,
     #  -0.48265, -0.43008, -0.29443, -0.13964, -0.06718,  0.22250,
     #   0.62662,  1.31054,  1.98906,  2.20670,  2.66413,  2.88091,
     #   3.55295,  4.22336,  5.10768,  5.77549,  6.44251,  7.98888 /
      DATA V20 /   -0.99990,
     #  -0.99950, -0.99900, -0.99800, -0.99499, -0.98995, -0.97980,
     #  -0.97468, -0.95918, -0.94871, -0.89464, -0.77686, -0.64333,
     #  -0.48917, -0.43854, -0.30685, -0.15516, -0.08371,  0.20397,
     #   0.60944,  1.30259,  1.99573,  2.21888,  2.68888,  2.91202,
     #   3.60517,  4.29832,  5.21461,  5.90776,  6.60090,  8.21034 /
      DATA V21 /   -0.95234,
     #  -0.95215, -0.95188, -0.95131, -0.94945, -0.94607, -0.93878,
     #  -0.93495, -0.92295, -0.91458, -0.86938, -0.76482, -0.64125,
     #  -0.49494, -0.44628, -0.31872, -0.17030, -0.09997,  0.18540,
     #   0.59183,  1.29377,  2.00128,  2.22986,  2.71234,  2.94181,
     #   3.65600,  4.37186,  5.32014,  6.03865,  6.75798,  8.43064 /
      DATA V22 /   -0.90908,
     #  -0.90899, -0.90885, -0.90854, -0.90742, -0.90521, -0.90009,
     #  -0.89728, -0.88814, -0.88156, -0.84422, -0.75211, -0.63833,
     #  -0.49991, -0.45329, -0.32999, -0.18504, -0.11590,  0.16682,
     #   0.57383,  1.28412,  2.00570,  2.23967,  2.73451,  2.97028,
     #   3.70543,  4.44398,  5.42426,  6.16816,  6.91370,  8.64971 /
      DATA V23 /   -0.86956,
     #  -0.86952, -0.86945, -0.86929, -0.86863, -0.86723, -0.86371,
     #  -0.86169, -0.85486, -0.84976, -0.81929, -0.73880, -0.63456,
     #  -0.50409, -0.45953, -0.34063, -0.19933, -0.13148,  0.14827,
     #   0.55549,  1.27365,  2.00903,  2.24831,  2.75541,  2.99744,
     #   3.75347,  4.51467,  5.52694,  6.29626,  7.06804,  8.86753 /
      DATA V24 /   -0.83333,
     #  -0.83331, -0.83328, -0.83320, -0.83283, -0.83196, -0.82959,
     #  -0.82817, -0.82315, -0.81927, -0.79472, -0.72495, -0.62999,
     #  -0.50744, -0.46499, -0.35062, -0.21313, -0.14665,  0.12979,
     #   0.53683,  1.26240,  2.01128,  2.25581,  2.77506,  3.02330,
     #   3.80013,  4.58393,  5.62818,  6.42292,  7.22098,  9.08403 /
      DATA V25 /   -0.80000,
     #  -0.79999, -0.79998, -0.79994, -0.79973, -0.79921, -0.79765,
     #  -0.79667, -0.79306, -0.79015, -0.77062, -0.71067, -0.62463,
     #  -0.50999, -0.46966, -0.35992, -0.22642, -0.16138,  0.11143,
     #   0.51789,  1.25039,  2.01247,  2.26217,  2.79345,  3.04787,
     #   3.84540,  4.65176,  5.72796,  6.54814,  7.37250,  9.29920 /
      DATA V26 /   -0.76923,
     #  -0.76923, -0.76922, -0.76920, -0.76909, -0.76878, -0.76779,
     #  -0.76712, -0.76456, -0.76242, -0.74709, -0.69602, -0.61854,
     #  -0.51171, -0.47353, -0.36852, -0.23915, -0.17564,  0.09323,
     #   0.49872,  1.23766,  2.01263,  2.26743,  2.81062,  3.07116,
     #   3.88930,  4.71815,  5.82629,  6.67191,  7.52258,  9.51301 /
      DATA V27 /   -0.74074,
     #  -0.74074, -0.74074, -0.74073, -0.74067, -0.74049, -0.73987,
     #  -0.73943, -0.73765, -0.73610, -0.72422, -0.68111, -0.61176,
     #  -0.51263, -0.47660, -0.37640, -0.25129, -0.18939,  0.07523,
     #   0.47934,  1.22422,  2.01177,  2.27160,  2.82658,  3.09320,
     #   3.93183,  4.78313,  5.92316,  6.79421,  7.67121,  9.72543 /
      DATA V28 /   -0.71429,
     #  -0.71429, -0.71428, -0.71428, -0.71425, -0.71415, -0.71377,
     #  -0.71348, -0.71227, -0.71116, -0.70209, -0.66603, -0.60434,
     #  -0.51276, -0.47888, -0.38353, -0.26282, -0.20259,  0.05746,
     #   0.45980,  1.21013,  2.00992,  2.27470,  2.84134,  3.11399,
     #   3.97301,  4.84669,  6.01858,  6.91505,  7.81839,  9.93643 /
      DATA V29 /   -0.68966,
     #  -0.68966, -0.68965, -0.68965, -0.68964, -0.68959, -0.68935,
     #  -0.68917, -0.68836, -0.68759, -0.68075, -0.65086, -0.59634,
     #  -0.51212, -0.48037, -0.38991, -0.27372, -0.21523,  0.03997,
     #   0.44015,  1.19539,  2.00710,  2.27676,  2.85492,  3.13356,
     #   4.01286,  4.90884,  6.11254,  7.03443,  7.96411, 10.14602 /
      DATA V30 /   -0.66667,
     #  -0.66667, -0.66667, -0.66667, -0.66666, -0.66663, -0.66649,
     #  -0.66638, -0.66585, -0.66532, -0.66023, -0.63569, -0.58783,
     #  -0.51073, -0.48109, -0.39554, -0.28395, -0.22726,  0.02279,
     #   0.42040,  1.18006,  2.00335,  2.27780,  2.86735,  3.15193,
     #   4.05138,  4.96959,  6.20506,  7.15235,  8.10836, 10.35418 /
      DATA V31 /   -0.64516,
     #  -0.64516, -0.64516, -0.64516, -0.64516, -0.64514, -0.64507,
     #  -0.64500, -0.64465, -0.64429, -0.64056, -0.62060, -0.57887,
     #  -0.50863, -0.48107, -0.40041, -0.29351, -0.23868,  0.00596,
     #   0.40061,  1.16416,  1.99869,  2.27785,  2.87865,  3.16911,
     #   4.08859,  5.02897,  6.29613,  7.26881,  8.25115, 10.56090 /
      DATA V32 /   -0.62500,
     #  -0.62500, -0.62500, -0.62500, -0.62500, -0.62499, -0.62495,
     #  -0.62491, -0.62469, -0.62445, -0.62175, -0.60567, -0.56953,
     #  -0.50585, -0.48033, -0.40454, -0.30238, -0.24946, -0.01050,
     #   0.38081,  1.14772,  1.99314,  2.27693,  2.88884,  3.18512,
     #   4.12452,  5.08697,  6.38578,  7.38382,  8.39248, 10.76618 /
      DATA V33 /   -0.60606,
     #  -0.60606, -0.60606, -0.60606, -0.60606, -0.60606, -0.60603,
     #  -0.60601, -0.60587, -0.60572, -0.60379, -0.59096, -0.55989,
     #  -0.50244, -0.47890, -0.40792, -0.31055, -0.25958, -0.02654,
     #   0.36104,  1.13078,  1.98674,  2.27506,  2.89795,  3.20000,
     #   4.15917,  5.14362,  6.47401,  7.49739,  8.53236, 10.97001 /
      DATA V34 /   -0.58824,
     #  -0.58824, -0.58824, -0.58824, -0.58824, -0.58823, -0.58822,
     #  -0.58821, -0.58812, -0.58802, -0.58666, -0.57652, -0.55000,
     #  -0.49844, -0.47682, -0.41058, -0.31802, -0.26904, -0.04215,
     #   0.34133,  1.11337,  1.97951,  2.27229,  2.90599,  3.21375,
     #   4.19257,  5.19892,  6.56084,  7.60953,  8.67079, 11.17239 /
      DATA V35 /   -0.57143,
     #  -0.57143, -0.57143, -0.57143, -0.57143, -0.57143, -0.57142,
     #  -0.57141, -0.57136, -0.57130, -0.57035, -0.56242, -0.53993,
     #  -0.49391, -0.47413, -0.41253, -0.32479, -0.27782, -0.05730,
     #   0.32171,  1.09552,  1.97147,  2.26862,  2.91299,  3.22641,
     #   4.22473,  5.25291,  6.64627,  7.72024,  8.80779, 11.37334 /
      DATA V36 /   -0.55556,
     #  -0.55556, -0.55556, -0.55556, -0.55556, -0.55556, -0.55555,
     #  -0.55555, -0.55552, -0.55548, -0.55483, -0.54867, -0.52975,
     #  -0.48888, -0.47088, -0.41381, -0.33085, -0.28592, -0.07195,
     #   0.30223,  1.07726,  1.96266,  2.26409,  2.91898,  3.23800,
     #   4.25569,  5.30559,  6.73032,  7.82954,  8.94335, 11.57284 /
      DATA V37 /   -0.54054,
     #  -0.54054, -0.54054, -0.54054, -0.54054, -0.54054, -0.54054,
     #  -0.54054, -0.54052, -0.54050, -0.54006, -0.53533, -0.51952,
     #  -0.48342, -0.46711, -0.41442, -0.33623, -0.29335, -0.08610,
     #   0.28290,  1.05863,  1.95311,  2.25872,  2.92397,  3.24853,
     #   4.28545,  5.35698,  6.81301,  7.93744,  9.07750, 11.77092 /
      DATA V38 /   -0.52632,
     #  -0.52632, -0.52632, -0.52632, -0.52632, -0.52632, -0.52631,
     #  -0.52631, -0.52630, -0.52629, -0.52600, -0.52240, -0.50929,
     #  -0.47758, -0.46286, -0.41441, -0.34092, -0.30010, -0.09972,
     #   0.26376,  1.03965,  1.94283,  2.25254,  2.92799,  3.25803,
     #   4.31403,  5.40711,  6.89435,  8.04395,  9.21023, 11.96757 /
      DATA V39 /   -0.51282,
     #  -0.51282, -0.51282, -0.51282, -0.51282, -0.51282, -0.51282,
     #  -0.51282, -0.51281, -0.51281, -0.51261, -0.50990, -0.49911,
     #  -0.47141, -0.45819, -0.41381, -0.34494, -0.30617, -0.11279,
     #   0.24484,  1.02036,  1.93186,  2.24558,  2.93107,  3.26653,
     #   4.34147,  5.45598,  6.97435,  8.14910,  9.34158, 12.16280 /
      DATA V40 /   -0.50000,
     #  -0.50000, -0.50000, -0.50000, -0.50000, -0.50000, -0.50000,
     #  -0.50000, -0.50000, -0.49999, -0.49986, -0.49784, -0.48902,
     #  -0.46496, -0.45314, -0.41265, -0.34831, -0.31159, -0.12530,
     #   0.22617,  1.00079,  1.92023,  2.23786,  2.93324,  3.27404,
     #   4.36777,  5.50362,  7.05304,  8.25289,  9.47154, 12.35663 /
      DATA V41 /   -0.48780,
     #  -0.48780, -0.48780, -0.48780, -0.48780, -0.48780, -0.48780,
     #  -0.48780, -0.48780, -0.48780, -0.48772, -0.48622, -0.47906,
     #  -0.45828, -0.44777, -0.41097, -0.35105, -0.31635, -0.13725,
     #   0.20777,  0.98096,  1.90796,  2.22940,  2.93450,  3.28060,
     #   4.39296,  5.55005,  7.13043,  8.35534,  9.60013, 12.54906 /
      DATA V42 /   -0.47619,
     #  -0.47619, -0.47619, -0.47619, -0.47619, -0.47619, -0.47619,
     #  -0.47619, -0.47619, -0.47619, -0.47614, -0.47504, -0.46927,
     #  -0.45142, -0.44212, -0.40881, -0.35318, -0.32049, -0.14861,
     #   0.18967,  0.96090,  1.89508,  2.22024,  2.93489,  3.28622,
     #   4.41706,  5.59528,  7.20654,  8.45646,  9.72737, 12.74010 /
      DATA V43 /   -0.46512,
     #  -0.46512, -0.46512, -0.46512, -0.46512, -0.46512, -0.46512,
     #  -0.46512, -0.46512, -0.46511, -0.46508, -0.46428, -0.45967,
     #  -0.44442, -0.43623, -0.40621, -0.35473, -0.32400, -0.15939,
     #   0.17189,  0.94064,  1.88160,  2.21039,  2.93443,  3.29092,
     #   4.44009,  5.63934,  7.28138,  8.55627,  9.85326, 12.92977 /
      DATA V44 /   -0.45455,
     #  -0.45455, -0.45455, -0.45455, -0.45455, -0.45455, -0.45455,
     #  -0.45455, -0.45455, -0.45454, -0.45452, -0.45395, -0.45029,
     #  -0.43734, -0.43016, -0.40321, -0.35572, -0.32693, -0.16958,
     #   0.15445,  0.92022,  1.86757,  2.19988,  2.93314,  3.29473,
     #   4.46207,  5.68224,  7.35497,  8.65479,  9.97784, 13.11808 /
      DATA V45 /   -0.44444,
     #  -0.44444, -0.44444, -0.44444, -0.44444, -0.44444, -0.44444,
     #  -0.44444, -0.44444, -0.44444, -0.44443, -0.44402, -0.44114,
     #  -0.43020, -0.42394, -0.39985, -0.35619, -0.32928, -0.17918,
     #   0.13737,  0.89964,  1.85300,  2.18874,  2.93105,  3.29767,
     #   4.48303,  5.72400,  7.42733,  8.75202, 10.10110, 13.30504 /
      DATA V46 /   -0.43478,
     #  -0.43478, -0.43478, -0.43478, -0.43478, -0.43478, -0.43478,
     #  -0.43478, -0.43478, -0.43478, -0.43477, -0.43448, -0.43223,
     #  -0.42304, -0.41761, -0.39617, -0.35616, -0.33108, -0.18819,
     #   0.12067,  0.87895,  1.83792,  2.17699,  2.92818,  3.29976,
     #   4.50297,  5.76464,  7.49847,  8.84800, 10.22307, 13.49066 /
      DATA V47 /   -0.42553,
     #  -0.42553, -0.42553, -0.42553, -0.42553, -0.42553, -0.42553,
     #  -0.42553, -0.42553, -0.42553, -0.42553, -0.42532, -0.42357,
     #  -0.41590, -0.41121, -0.39221, -0.35567, -0.33236, -0.19661,
     #   0.10436,  0.85817,  1.82234,  2.16465,  2.92455,  3.30103,
     #   4.52192,  5.80418,  7.56842,  8.94273, 10.34375, 13.67495 /
      DATA V48 /   -0.41667,
     #  -0.41667, -0.41667, -0.41667, -0.41667, -0.41667, -0.41667,
     #  -0.41667, -0.41667, -0.41667, -0.41666, -0.41652, -0.41517,
     #  -0.40880, -0.40477, -0.38800, -0.35475, -0.33315, -0.20446,
     #   0.08847,  0.83731,  1.80631,  2.15174,  2.92017,  3.30149,
     #   4.53990,  5.84265,  7.63718,  9.03623, 10.46318, 13.85794 /
      DATA V50 /   -0.40000,
     #  -0.40000, -0.40000, -0.40000, -0.40000, -0.40000, -0.40000,
     #  -0.40000, -0.40000, -0.40000, -0.40000, -0.39993, -0.39914,
     #  -0.39482, -0.39190, -0.37901, -0.35174, -0.33336, -0.21843,
     #   0.05798,  0.79548,  1.77292,  2.12432,  2.90930,  3.30007,
     #   4.57304,  5.91639,  7.77124,  9.21961, 10.69829, 14.22004 /
      DATA V52 /   -0.38462,
     #  -0.38462, -0.38462, -0.38462, -0.38462, -0.38462, -0.38462,
     #  -0.38462, -0.38462, -0.38462, -0.38462, -0.38458, -0.38414,
     #  -0.38127, -0.37919, -0.36945, -0.34740, -0.33194, -0.23019,
     #   0.02927,  0.75364,  1.73795,  2.09490,  2.89572,  3.29567,
     #   4.60252,  5.98602,  7.90078,  9.39827, 10.92853, 14.57706 /
      DATA V54 /   -0.37037,
     #  -0.37037, -0.37037, -0.37037, -0.37037, -0.37037, -0.37037,
     #  -0.37037, -0.37037, -0.37037, -0.37037, -0.37036, -0.37011,
     #  -0.36825, -0.36680, -0.35956, -0.34198, -0.32914, -0.23984,
     #   0.00243,  0.71195,  1.70155,  2.06365,  2.87959,  3.28844,
     #   4.62850,  6.05169,  8.02594,  9.57232, 11.15402, 14.92912 /
      DATA V56 /   -0.35714,
     #  -0.35714, -0.35714, -0.35714, -0.35714, -0.35714, -0.35714,
     #  -0.35714, -0.35714, -0.35714, -0.35714, -0.35714, -0.35700,
     #  -0.35583, -0.35484, -0.34955, -0.33573, -0.32519, -0.24751,
     #  -0.02252,  0.67058,  1.66390,  2.03073,  2.86107,  3.27854,
     #   4.65111,  6.11351,  8.14683,  9.74190, 11.37487, 15.27632 /
      DATA V58 /   -0.34483,
     #  -0.34483, -0.34483, -0.34483, -0.34483, -0.34483, -0.34483,
     #  -0.34483, -0.34483, -0.34483, -0.34483, -0.34483, -0.34476,
     #  -0.34402, -0.34336, -0.33957, -0.32886, -0.32031, -0.25334,
     #  -0.04553,  0.62966,  1.62513,  1.99629,  2.84030,  3.26610,
     #   4.67050,  6.17162,  8.26359,  9.90713, 11.59122, 15.61878 /
      DATA V60 /   -0.33333,
     #  -0.33333, -0.33333, -0.33333, -0.33333, -0.33333, -0.33333,
     #  -0.33333, -0.33333, -0.33333, -0.33333, -0.33333, -0.33330,
     #  -0.33285, -0.33242, -0.32974, -0.32155, -0.31472, -0.25750,
     #  -0.06662,  0.58933,  1.58541,  1.96048,  2.81743,  3.25128,
     #   4.68680,  6.22616,  8.37634, 10.06812, 11.80316, 15.95660 /
      DATA V62 /   -0.32258,
     #  -0.32258, -0.32258, -0.32258, -0.32258, -0.32258, -0.32258,
     #  -0.32258, -0.32258, -0.32258, -0.32258, -0.32258, -0.32256,
     #  -0.32230, -0.32202, -0.32016, -0.31399, -0.30859, -0.26015,
     #  -0.08580,  0.54970,  1.54487,  1.92343,  2.79259,  3.23419,
     #   4.70013,  6.27723,  8.48519, 10.22499, 12.01082, 16.28989 /
      DATA V64 /   -0.31250,
     #  -0.31250, -0.31250, -0.31250, -0.31250, -0.31250, -0.31250,
     #  -0.31250, -0.31250, -0.31250, -0.31250, -0.31250, -0.31249,
     #  -0.31234, -0.31216, -0.31090, -0.30631, -0.30209, -0.26146,
     #  -0.10311,  0.51089,  1.50365,  1.88528,  2.76591,  3.21497,
     #   4.71061,  6.32497,  8.59027, 10.37785, 12.21429, 16.61875 /
      DATA V66 /   -0.30303,
     #  -0.30303, -0.30303, -0.30303, -0.30303, -0.30303, -0.30303,
     #  -0.30303, -0.30303, -0.30303, -0.30303, -0.30303, -0.30303,
     #  -0.30294, -0.30283, -0.30198, -0.29862, -0.29537, -0.26160,
     #  -0.11859,  0.47299,  1.46186,  1.84616,  2.73751,  3.19374,
     #   4.71836,  6.36948,  8.69167, 10.52681, 12.41370, 16.94329 /
      DATA V68 /   -0.29412,
     #  -0.29412, -0.29412, -0.29412, -0.29412, -0.29412, -0.29412,
     #  -0.29412, -0.29412, -0.29412, -0.29412, -0.29412, -0.29412,
     #  -0.29407, -0.29400, -0.29344, -0.29101, -0.28854, -0.26072,
     #  -0.13231,  0.43608,  1.41963,  1.80618,  2.70751,  3.17062,
     #   4.72350,  6.41086,  8.78950, 10.67197, 12.60913, 17.26360 /
      DATA V70 /   -0.28571,
     #  -0.28571, -0.28571, -0.28571, -0.28571, -0.28571, -0.28571,
     #  -0.28571, -0.28571, -0.28571, -0.28571, -0.28571, -0.28571,
     #  -0.28569, -0.28565, -0.28528, -0.28355, -0.28169, -0.25899,
     #  -0.14434,  0.40026,  1.37708,  1.76547,  2.67603,  3.14572,
     #   4.72613,  6.44924,  8.88387, 10.81343, 12.80069, 17.57979 /
      DATA V72 /   -0.27778,
     #  -0.27778, -0.27778, -0.27778, -0.27778, -0.27778, -0.27778,
     #  -0.27778, -0.27778, -0.27778, -0.27778, -0.27778, -0.27778,
     #  -0.27776, -0.27774, -0.27751, -0.27629, -0.27491, -0.25654,
     #  -0.15478,  0.36557,  1.33430,  1.72412,  2.64317,  3.11914,
     #   4.72635,  6.48470,  8.97488, 10.95129, 12.98848, 17.89193 /
      DATA V74 /   -0.27027,
     #  -0.27027, -0.27027, -0.27027, -0.27027, -0.27027, -0.27027,
     #  -0.27027, -0.27027, -0.27027, -0.27027, -0.27027, -0.27027,
     #  -0.27026, -0.27025, -0.27010, -0.26926, -0.26825, -0.25352,
     #  -0.16371,  0.33209,  1.29141,  1.68225,  2.60905,  3.09099,
     #   4.72427,  6.51735,  9.06261, 11.08565, 13.17258, 18.20012 /
      DATA V76 /   -0.26316,
     #  -0.26316, -0.26316, -0.26316, -0.26316, -0.26316, -0.26316,
     #  -0.26316, -0.26316, -0.26316, -0.26316, -0.26316, -0.26316,
     #  -0.26315, -0.26315, -0.26306, -0.26248, -0.26175, -0.25005,
     #  -0.17123,  0.29986,  1.24850,  1.63995,  2.57375,  3.06137,
     #   4.71998,  6.54727,  9.14717, 11.21658, 13.35309, 18.50446 /
      DATA V78 /   -0.25641,
     #  -0.25641, -0.25641, -0.25641, -0.25641, -0.25641, -0.25641,
     #  -0.25641, -0.25641, -0.25641, -0.25641, -0.25641, -0.25641,
     #  -0.25641, -0.25640, -0.25635, -0.25596, -0.25544, -0.24622,
     #  -0.17746,  0.26892,  1.20565,  1.59732,  2.53737,  3.03038,
     #   4.71358,  6.57456,  9.22863, 11.34419, 13.53009, 18.80504 /
      DATA V80 /   -0.25000,
     #  -0.25000, -0.25000, -0.25000, -0.25000, -0.25000, -0.25000,
     #  -0.25000, -0.25000, -0.25000, -0.25000, -0.25000, -0.25000,
     #  -0.25000, -0.25000, -0.24996, -0.24970, -0.24933, -0.24214,
     #  -0.18249,  0.23929,  1.16295,  1.55444,  2.50001,  2.99810,
     #   4.70514,  6.59931,  9.30709, 11.46855, 13.70366, 19.10190 /
      DATA V82 /   -0.24390,
     #  -0.24390, -0.24390, -0.24390, -0.24390, -0.24390, -0.24390,
     #  -0.24390, -0.24390, -0.24390, -0.24390, -0.24390, -0.24390,
     #  -0.24390, -0.24390, -0.24388, -0.24371, -0.24345, -0.23788,
     #  -0.18643,  0.21101,  1.12048,  1.51141,  2.46175,  2.96462,
     #   4.69476,  6.62159,  9.38262, 11.58974, 13.87389, 19.39516 /
      DATA V84 /   -0.23810,
     #  -0.23810, -0.23810, -0.23810, -0.23810, -0.23810, -0.23810,
     #  -0.23810, -0.23810, -0.23810, -0.23810, -0.23810, -0.23810,
     #  -0.23810, -0.23809, -0.23808, -0.23797, -0.23779, -0.23352,
     #  -0.18939,  0.18408,  1.07832,  1.46829,  2.42268,  2.93002,
     #   4.68252,  6.64148,  9.45530, 11.70785, 14.04086, 19.68488 /
      DATA V86 /   -0.23256,
     #  -0.23256, -0.23256, -0.23256, -0.23256, -0.23256, -0.23256,
     #  -0.23256, -0.23256, -0.23256, -0.23256, -0.23256, -0.23256,
     #  -0.23256, -0.23256, -0.23255, -0.23248, -0.23236, -0.22911,
     #  -0.19147,  0.15851,  1.03654,  1.42518,  2.38288,  2.89440,
     #   4.66850,  6.65907,  9.52521, 11.82294, 14.20463, 19.97115 /
      DATA V88 /   -0.22727,
     #  -0.22727, -0.22727, -0.22727, -0.22727, -0.22727, -0.22727,
     #  -0.22727, -0.22727, -0.22727, -0.22727, -0.22727, -0.22727,
     #  -0.22727, -0.22727, -0.22727, -0.22722, -0.22714, -0.22469,
     #  -0.19277,  0.13431,  0.99519,  1.38213,  2.34242,  2.85782,
     #   4.65277,  6.67443,  9.59243, 11.93509, 14.36528, 20.25402 /
      DATA V90 /   -0.22222,
     #  -0.22222, -0.22222, -0.22222, -0.22222, -0.22222, -0.22222,
     #  -0.22222, -0.22222, -0.22222, -0.22222, -0.22222, -0.22222,
     #  -0.22222, -0.22222, -0.22222, -0.22219, -0.22214, -0.22030,
     #  -0.19338,  0.11146,  0.95435,  1.33922,  2.30138,  2.82035,
     #   4.63541,  6.68763,  9.65701, 12.04437, 14.52288, 20.53356 /
C
C
C      VERSION FOR HARRIS 9/79 HAS LOCAL COPY OF TABLES NOT COMMON.
C      G387 - LOOK UP K OR P IN HARTERS TABLES.  WKIRBY 3/75. 9/76.G387.
C      HARTIV -- HARTER INTERPOLATE VECTOR PD BY 3-PT LAGRANGE INT W/R SKEW
C      REV 9/76 WK - NO LONGER USES SKEW TABLES IN HARTAB
C      ERROR IN IORDER MADE 9/76, CORRECTED 7/77. FOR SKU IN (-.05,-0.)
C       NOTE- ABS SKEW IS TRUNCATED AT 9. W/OUT COMMENT.
C      G387 --  HARTERS TABLES OF PEARSON TYPE III DISTRIBUTION.
C        TECHNOMETRICS FEB 69 AND FEB 71.  THESE TABLES IN HARTAB
C        HAVE BEEN CHECKED AGAINST ANOTHER SET OF TABLES LOANED BY
C        W. H. SAMMONS OF SOIL CONS. SERVICE.
C        W.KIRBY  USGS-WRD 3/73.
C      SKEWS = -0.1, 0.0(0.1)4.8,  5.0(0.2)9.0
C
C      TABULAR PROBABILITIES /    0.00010,
C       0.00050,  0.00100,  0.00200,  0.00500,  0.01000,  0.02000,
C       0.02500,  0.04000,  0.05000,  0.10000,  0.20000,  0.30000,
C       0.40000,  0.429624, 0.50000,  0.570376, 0.60000,  0.70000,
C       0.80000,  0.90000,  0.95000,  0.96000,  0.97500,  0.98000,
C       0.99000,  0.99500,  0.99800,  0.99900,  0.99950,  0.99990 /
C
      IORDER=1
      IF (SKU.LT. 0.0)IORDER=-1
      S=ABS(SKU)
      IF (S.LE.9.01) THEN
        IF (S.GT.4.75 .AND. S.LT.4.90) THEN
          KKTV=50
          P=S-4.8
          Q=S-5.0
          R=S-4.7
          C2=P*R*16.66667*FLOAT(IORDER)
          C1=Q*R*(-50.)  *FLOAT(IORDER)
          C0=P*Q*33.33333*FLOAT(IORDER)
        ELSE
          H=0.1
          IF (S.GT.4.75)H=0.2
          KKTV=50+(S-4.8)/H + .5
          IF (KKTV.GT.70)KKTV=70
          SKTV = 4.8 + H*(KKTV-50)
          P = (S - SKTV)/H
          C0=P*(P-1.)*.5 *FLOAT(IORDER)
          C1=(1.-P**2)   *FLOAT(IORDER)
          C2=P*(P+1.)*.5 *FLOAT(IORDER)
        END IF
        L=16*(1-IORDER)
        DO 10 I=1,31
          L=L+IORDER
          PD(L)=C0*PCT(I,KKTV-1)  + C1*PCT(I,KKTV) + C2*PCT(I,KKTV+1)
 10     CONTINUE
      ELSE
        DO 20 I=1,31
          PD(I)=0.
 20     CONTINUE
      END IF
C
      RETURN
      END
C
C
C
      REAL   FUNCTION   HARTK1
     I                        (P, V)
C
C     + + + PURPOSE + + +
C     This function looks up the P-th quantile (standardized deviate
C     with non-exceedence probability p) of the standardized Pearson
C     Type III distribution tabulated in the vector V.  The vector V
C     must have been filled by a prior call to HARTIV.  The value of
C     P must be between 0.0001 and 0.9999.
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   P, V(31)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     P      - quantile of Pearson Type III distribution
C     V      - vector of skew-interpolated Harter K values from HARTIV
C
C     + + + LOCAL VARIABLES + + +
      REAL PROB(31), HUGE, HARTK
      INTEGER   IB, IE, I
C
C     + + + DATA INITIALIZATIONS + + +
C     HARTER TABULAR PROBABILITIES OR  GAUSSIAN DEVIATES -------------
      DATA PROB     /   0.00010,
     #   0.00050,  0.00100,  0.00200,  0.00500,  0.01000,  0.02000,
     #   0.02500,  0.04000,  0.05000,  0.10000,  0.20000,  0.30000,
     #   0.40000,  0.429624, 0.50000,  0.570376, 0.60000,  0.70000,
     #   0.80000,  0.90000,  0.95000,  0.96000,  0.97500,  0.98000,
     #   0.99000,  0.99500,  0.99800,  0.99900,  0.99950,  0.99990 /
      DATA HUGE / 1E29/
C
C     + + + END SPECIFICATIONS + + +
C
C     G387 - LOOK UP K OR P IN HARTERS TABLES.  WKIRBY 9/76.
C     HARTK  - LOOKUP STDIZED HARTER K AT CUMULATIVE PROB P
C     HARTP  - LOOKUP CUM (NONEXCEED) PROB P AT STDIZED HARTER K
C     V      - VECTOR OF SKEW-INTERPOLATED HARTER K VALUES (FROM HARTIV)
C     6/78 WK -- USING LOCAL NOT HARTAB COPY OF HARTER TAB PROBS/GAUSS DEV.
C
      IF (P.GT.PROB(31) .OR. P.LT.PROB(1)) THEN
C       RETURN + OR - 1E29 IF OUT OF RANGE OF PROB
        HARTK=HUGE
        IF (P.LT.PROB(1))HARTK=-HUGE
      ELSE
        IB=2
        IF (P.GE.0.5)IB=17
        IE=IB+13
        DO10I=IB,IE
          IF (P.LT.PROB(I))GOTO20
 10     CONTINUE
        I=IB+14
 20     HARTK=V(I-1)+(P-PROB(I-1))*(V(I)-V(I-1))/(PROB(I)-PROB(I-1))
      END IF
C
      HARTK1 = HARTK
C
      RETURN
      END
C
C
C
      REAL   FUNCTION   HARTRG
     I                         (R)
C
C     + + + PURPOSE + + +
C     This function returns the value of the skew coefficient
C     corresponding to the given value of the 2-10-100 quantile
C     ratio, QR = (X100-X10)/(X10-X2), in which Xt is the t-yr
C     quantile of a Pearson Type III distribution.  The results
C     are obtained from emperical ploynomial and semi-log formulas
C     that correlate skew-values and quantile-ratios from Harter's
C     tables.
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   R
C
C     + + + ARGUMENT DEFINITIONS + + +
C     R      - ratio (X100-X10)/(X10-X2)
C
C     + + + INTRINSICS + + +
      INTRINSIC   ALOG10, SQRT
C
C     + + + END SPECIFICATIONS + + +
C      COMPUTES SKEW COEFF OF PEARSON TYPE III  DISTN,
C      GIVEN THE RATIO (Q.100 - Q.10)/(Q.10 - Q.2),
C      WHERE Q.T IS THE T-YEAR (1.-1/T - PROBABILITY)
C      QUANTILE.   THE EQUATIONS WERE FOUND BY POLYNOMIAL
C      REGRESSION, ETC., OF SKEW VS RATIO, WHERE THE RATIOS
C      WERE LOOKED UP IN HARTER'S TABLES FOR GIVEN SKEWS.
C         WK 11/80.  FOR WRC BULL 17-B.
C
      IF (R.LT.0.243) THEN
        HARTRG = -4.8
        IF (R.GT.0.) HARTRG = -6.0 + 10.**(0.72609+0.15397*ALOG10(R))
      ELSE IF (R.GT.1.6) THEN
        HARTRG = 7.1+1.6*(R-2.4)-1.4*SQRT((R-2.4)**2+5.1888)
      ELSE
        HARTRG = -2.51898 + R*(3.82069 + R*(-2.31960 +
     $           R*(2.35713 + R*(-0.73870))))
      END IF
C
      RETURN
      END
C
C
C
      REAL   FUNCTION   OUTKGB
     I                           (SIG, N)
C
C     This function returns the value of the Grubbs-Beck (1972)
C     one-sided single-outlier criterion for narmal samples of size N at
C     significance level SIG.  Sample size N must be at least 3.  Available
C     Available significane levels are 1.0, 2.5, 5.0, and 10.0 percent.
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   SIG
      INTEGER   N
C
C     + + + ARGUMENT DEFINITIONS + + +
C     SIG    - significance level
C     N      - sample size
C
C     + + + SAVE VARIABLES + + +
      SAVE    OUTG10,OUTG5,OUTG25,OUTG1
      REAL    OUTG10(100),OUTG5(100),OUTG25(100),OUTG1(100)
C
C     + + + LOCAL VARIABLES + + +
      REAL    OUTG(100,4), TAIL(2,4), SIGG
      INTEGER   NN, ISIG
C
C     + + + EQUIVALENCES + + +
      EQUIVALENCE(OUTG10(1),OUTG(1,1)),(OUTG5(1),OUTG(1,2)),
     $         (OUTG25(1),OUTG(1,3)), (OUTG1(1),OUTG(1,4))
C
C     + + + INTRINSICS + + +
      INTRINSIC   ABS, MAX0, MIN0
C
C     + + + DATA INITIALIZATIONS + + +
      DATA OUTG10/       2*-1E29,
     $1.148,1.425,1.602,1.729,1.828,1.909,1.977,            2.036,2.088,
     12.134,2.175,2.213,2.247,2.279,2.309,2.335,2.361,2.385,2.408,2.429,
     22.448,2.467,2.486,2.502,2.519,2.534,2.549,2.563,2.577,2.591,2.604,
     32.616,2.628,2.639,2.650,2.661,2.671,2.682,2.692,2.700,2.710,2.719,
     42.727,2.736,2.744,2.753,2.760,2.768,2.775,2.783,2.790,2.798,2.804,
     52.811,2.818,2.824,2.831,2.837,2.842,2.849,2.854,2.860,2.866,2.871,
     62.877,2.883,2.888,2.893,2.897,2.903,2.908,2.912,2.917,2.922,2.927,
     72.931,2.935,2.940,2.945,2.949,2.953,2.957,2.961,2.966,2.970,2.973,
     82.977,2.981,2.984,2.989,2.993,2.996,3.000,3.003,3.006,3.011,3.014,
     93.017/
      DATA OUTG5 /   2*-1E29,
     $1.153,1.463,1.672,1.822,1.938,2.032,2.110,2.176,2.234,
     12.285,2.331,2.371,2.409,2.443,2.475,2.504,2.532,2.557,2.580,2.603,
     22.624,2.644,2.663,2.681,2.698,2.714,2.730,2.745,2.759,2.773,2.786,
     32.799,2.811,2.823,2.835,2.846,2.857,2.866,2.877,2.887,2.896,2.905,
     42.914,2.923,2.931,2.940,2.948,2.956,2.964,2.971,2.978,2.986,2.992,
     53.000,3.006,3.013,3.019,3.025,3.032,3.037,3.044,3.049,3.055,3.061,
     63.066,3.071,3.076,3.082,3.087,3.092,3.098,3.102,3.107,3.111,3.117,
     73.121,3.125,3.130,3.134,3.139,3.143,3.147,3.151,3.155,3.160,3.163,
     83.167,3.171,3.174,3.179,3.182,3.186,3.189,3.193,3.196,3.201,3.204,
     93.207/
      DATA OUTG25/       2*-1E29,
     $1.155,1.481,1.715,1.887,2.020,2.126,2.215,2.290,2.355,
     12.412,2.462,2.507,2.549,2.585,2.620,2.651,2.681,2.709,2.733,2.758,
     22.781,2.802,2.822,2.841,2.859,2.876,2.893,2.908,2.924,2.938,2.952,
     32.965,2.979,2.991,3.003,3.014,3.025,3.036,3.046,3.057,3.067,3.075,
     43.085,3.094,3.103,3.111,3.120,3.128,3.136,3.143,3.151,3.158,3.166,
     53.172,3.180,3.186,3.193,3.199,3.205,3.212,3.218,3.224,3.230,3.235,
     63.241,3.246,3.252,3.257,3.262,3.267,3.272,3.278,3.282,3.287,3.291,
     73.297,3.301,3.305,3.309,3.315,3.319,3.323,3.327,3.331,3.335,3.339,
     83.343,3.347,3.350,3.355,3.358,3.362,3.365,3.369,3.372,3.377,3.380,
     93.383/
      DATA OUTG1  / 2*-1E29,
     $1.155,1.492,1.749,1.944,2.097,2.221,2.323,2.410,2.485,2.550,2.607,
     $2.659,2.705,2.747,2.785,2.821,2.854,2.884,2.912,2.939,2.963,2.987,
     $3.009,3.029,3.049,3.068,3.085,3.103,3.119,3.135,3.150,3.164,3.178,
     $3.191,3.204,3.216,3.228,3.240,3.251,3.261,3.271,3.282,3.292,3.302,
     $3.310,3.319,3.329,3.336,3.345,3.353,3.361,3.368,3.376,3.383,3.391,
     $3.397,3.405,3.411,3.418,3.424,3.430,3.437,3.442,3.449,3.454,3.460,
     $3.466,3.471,3.476,3.482,3.487,3.492,3.496,3.502,3.507,3.511,3.516,
     $3.521,3.525,3.529,3.534,3.539,3.543,3.547,3.551,3.555,3.559,3.563,
     $3.567,3.570,3.575,3.579,3.582,3.586,3.589,3.593,3.597,3.600  /
      DATA TAIL /3.078,3.144,3.267,3.334,3.444,3.509,3.662,3.727/
C
C     HIGH-OUTLIER CRITERIA FOR NORMAL DTN.  - OUTKGB IS LOW-OUT CRIT.
C     OUTLIER TEST CRITERIA FROM GRUBBS-BECK 11/72 TECHNOMETRICS.
C     SAMPLE SIZES (3,1,100)  SIG LEVELS 10, 5, 2.5, 1  PCT (ONE-SIDED TEST
C     LINEAR INTERPOLATION-EXTRAP FOR N = 101-120-147-180.
C     SIG MAY BE GIVEN AS FRACTION OR PERCENT -- EG, 2.5 OR 0.025.
C     ORIGINAL TABLES FROM CRONSHEY, 7/77.  REVISED AND ENLARGED WK 5,6/78.
C
Caml  all E37's changed to E29's for 5/94 compiler
      SIGG = SIG
      IF (SIGG.GT..99) SIGG = 0.01*SIGG
      ISIG = 0
      IF ( ABS(SIGG -  .10  ) .LE. 0.001)  ISIG =  1
      IF ( ABS(SIGG -  .05  ) .LE. 0.001)  ISIG =  2
      IF ( ABS(SIGG -  .025 ) .LE. 0.001)  ISIG =  3
      IF (ABS(SIGG- .010) .LE. 0.001) ISIG = 4
      OUTKGB = -1E29
      IF (ISIG.NE.0) THEN
        IF (N.LE.120) THEN
          NN = MIN0(100, MAX0(1, N))
          OUTKGB = OUTG(NN,ISIG)
          IF (N.GT.100)OUTKGB=OUTKGB + .05*(N-100)*(TAIL(1,ISIG)-OUTKGB)
        ELSE
          NN = MIN0(N,180)
          OUTKGB=TAIL(1,ISIG)+(TAIL(2,ISIG)-TAIL(1,ISIG))*(NN-120)/27.
        END IF
      END IF
C
      RETURN
      END
C
C
C
      REAL   FUNCTION   STUTX
     I                        (P, N)
C
C     + + + PURPOSE + + +
C     This function returns the P-th quantile of Student's t with n
C     degrees of freedom.  It solves for x  in the equation
C     P{tn < x} = p  for the given value of p.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   N
      REAL   P
C
C     + + + ARGUMENT DEFINITIONS + + +
C     P      - quantile of Student's t
C     N      - degrees of freedom
C
C     + + + LOCAL VARIABLES + + +
C     INTEGER   IER
      REAL   HPI, SIGN, Q, FN, A, B, C, D, X, Y
C
C     + + + FUNCTIONS + + +
      REAL   GAUSAB
C
C     + + + INTRINSICS + + +
      INTRINSIC   TAN, SQRT, EXP
C
C     + + + EXTERNALS + + +
      EXTERNAL   GAUSAB
C
C     + + + DATA INITIALIZATIONS + + +
      DATA HPI / 1.5707963268/
C
C     + + + END SPECIFICATIONS + + +
C     STUDENT T QUANTILES --
C     STUTX(P,N) = X SUCH THAT PROB(STUDENT T WITH N D.F. .LE. X) = P.
C     NOTE - ABS(T) HAS PROB Q OF EXCEEDING STUTX( 1.-Q/2., N ).
C     NOTE -      IER - ERROR FLAG --  1 = F.LT.1.,
C                                  2 = P NOT  IN (0,1),  3 = 1+2
C     SUBPGMS USED -- GAUSAB     (GAUSSIAN ABSCISSA)
C     REF - G. W. HILL (1970) ACM ALGO 396.  COMM ACM 13(10)619-20.
C            REV BY WKIRBY 10/76. 2/79.  10/79.
CAML  E38 changed to E29 for 5/94 compiler
C
      SIGN=1.
      IF (P.LT.0.5)SIGN=-1.
      Q=2.*P
      IF (Q.GT.1.)Q=2.*(1.-P)
      IF (Q .GE. 1.) THEN
        STUTX = 0.
      ELSE
        FN = N
        IF (N.GE.1 .AND. Q.GT.0. .AND. Q.LT.1.) THEN
          IF (N .EQ. 1) THEN
C           1 DEG FR - EXACT
            STUTX=SIGN/TAN(HPI*Q)
C
          ELSE IF (N.EQ.2) THEN
C           2 DEG FR - EXACT
            STUTX = SQRT(2.0/(Q*(2.0-Q))-2.0) * SIGN
C
          ELSE
C           EXPANSION FOR N .GT. 2
            A = 1.0/(FN-0.5)
            B= 48.0/(A*A)
            C=((20700.*A/B-98.)*A-16.)*A+96.36
            D =  ((94.5/(B+C)-3.)/B+1.)*SQRT(A*HPI)*FN
            X = D*Q
            Y = X**(2.0/FN)
            IF (Y .LE. A+.05) THEN
              Y = ((1.0/(((FN+6.)/(FN*Y)-0.089*D-0.822)*(FN+2.)*3.)+
     $             0.5/(FN+4.))*Y-1.)*(FN+1.)/(FN+2.)+1.0/Y
              STUTX = SQRT(FN*Y) * SIGN
C
            ELSE
C             ASYMPTOTIC INVERSE EXPANSION ABOUT NORMAL
              X = GAUSAB(0.5*Q)
              Y =  X*X
              IF (FN .LT. 5.) C = C+0.3*(FN-4.5)*(X+0.6)
              C = (((.05*D*X-5.)*X-7.)*X-2.)*X+B+C
              Y = (((((0.4*Y+6.3)* Y+36.)*Y+94.5)/C-Y-3.)/B+1.)*X
              X = A*Y**2
              Y = X + 0.5*X**2
              IF (X .GT. .002) Y = EXP(X) - 1.0
              STUTX = SQRT(FN*Y) * SIGN
            END IF
          END IF
        ELSE
C         IER never used,  needs to be checked
C         IER = 3
C         IF (N.GE.1) IER = 2
          STUTX = SIGN*1E29
        END IF
      END IF
C
      RETURN
      END
C
C
C
      REAL   FUNCTION   HARTK
     I                        (P, V)
C
C     + + + PURPOSE + + +
C     This function looks up the P-th quantile (standardized deviate
C     with non-exceedence probability p) of the standardized Pearson
C     Type III distribution tabulated in the vector V.  The vector V
C     must have been filled by a prior call to HARTIV.  The value of
C     P must be between 0.0001 and 0.9999.
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   P, V(31)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     P      - quantile of Pearson Type III distribution
C     V      - vector of skew-interpolated Harter K values from HARTIV
C
C     + + + LOCAL VARIABLES + + +
      REAL   TMP
C
C     + + + FUNCTIONS + + + 
      REAL HARTK2
C
C     + + + EXTERNALS + + +
      EXTERNAL   HARTK2
C
C     + + + END SPECIFICATIONS + + + 
C
      TMP   = HARTK2 (P, V)
      HARTK = TMP
C
      RETURN
      END

      REAL FUNCTION HARTK2 (PA,V)
C
C
C     + + + PURPOSE + + +
C     This function looks up the P-th quantile (standardized deviate
C     with non-exceedence probability p) of the standardized Pearson
C     Type III distribution tabulated in the vector V.  The vector V
C     must have been filled by a prior call to HARTIV.  The value of
C     P must be between 0.0001 and 0.9999.
C
C     HARTK2 /HARTP2 -- Look up K or P in Harter tables using probability-
C                    scale interpolation in P (rather than simple linear
C                    as in HARTK/P).  WK 7/90. AML 12/93 (coding convention)
C     Based on HARTK routine.  The table of tabular probabilities in HARTK
C     is replaced by corresponding STD Normal deviates.   The input
C     probability
C     PA IN HARTK IS CONVERTED TO STD NORMAL DEVIATE BEFORE LINEAR INTERPOLATION
C     IS DONE.   IN HARTK2, LINEAR INTERPOLATION WITH RESPECT TO K-VALUES
C     YIELDS A STD NORMAL DEVIATE VALUE, WHICH IS CONVERTED TO PROBABILITY
C     FOR RETURN AS FUNCTION VALUE.
C
C     G387 - LOOK UP K OR P IN HARTERS TABLES.  WKIRBY 9/76.
C     HARTK  - LOOKUP STDIZED HARTER K AT CUMULATIVE PROB P
C     HARTP  - LOOKUP CUM (NONEXCEED) PROB P AT STDIZED HARTER K
C     V      - VECTOR OF SKEW-INTERPOLATED HARTER K VALUES (FROM HARTIV)
C     6/78 WK -- USING LOCAL NOT HARTAB COPY OF HARTER TAB PROBS/GAUSS DEV.
C
C     + + + DUMMY ARGUMENTS + + + 
      REAL   V(31), PA
C
C     + + + ARGUMENT DEFINITION + + +
C     PA     - probability
C     V      - vector of skew-interpolated Harter K values (from HARTIV)
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I, IB, IE
      REAL      PROB(31), HUGE, HARTK, P
C
C     + + + FUNCTIONS + + +
      REAL  GAUSAB 
C
C     + + + EXTERNALS + + + 
      EXTERNAL   GAUSAB
C
C     + + + DATA INITIALIZATIONS + + + 
C     HARTER TABULAR PROBABILITIES OR  GAUSSIAN DEVIATES -------------
      DATA PROB /   -3.71902,
     #  -3.29053, -3.09023, -2.87816, -2.57583, -2.32635, -2.05375,
     #  -1.95996, -1.75069, -1.64485, -1.28155, -0.84162, -0.52440,
     #  -0.25335, -0.17733,  0.0    ,  0.17733,  0.25335,  0.52440,
     #   0.84162,  1.28155,  1.64485,  1.75069,  1.95996,  2.05375,
     #   2.32635,  2.57583,  2.87816,  3.09023,  3.29053,  3.71902 /
      DATA HUGE / 1E29/
C
C     + + + END SPECIFICATIONS + + + 
Caml  E37 changed to E29 for 5/94 compiler
C
      P = GAUSAB(PA)
      IF(P.LE.PROB(31).AND. P.GE.PROB(1)) THEN 
        IB=2
        IF(P.GE.0.5)IB=17
        IE=IB+13
        DO 10 I=IB,IE
          IF(P.LT.PROB(I)) GOTO20
 10     CONTINUE
        I=IB+14
 20     HARTK=V(I-1)+(P-PROB(I-1))*(V(I)-V(I-1))/(PROB(I)-PROB(I-1))
      ELSE
C       RETURN + OR - 1E29 IF OUT OF RANGE OF PROB
        HARTK=HUGE
        IF(P.LT.PROB(1))HARTK=-HUGE
      END IF
C
      HARTK2 = HARTK
C
      RETURN
      END
