C
C
C
      SUBROUTINE   RANKLW
     I                  (N,
     M                   X)
C
C     + + + PURPOSE + + +
C     sorts an array in ascending order, max of 120.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   N
      REAL      X(120)
C
C     + + + ARGUMENT DEFINITIONS + + +
C     N      - size of array to be sorted,
C              maximum of 120
C     X      - array to be sorted
C
C     + + + LOCAL VARIABLES + + +
      REAL Z(120), BIG, XMIN
      INTEGER   M,K,I,J,IK,IJ
C
C     + + + END SPECIFICATIONS + + +
C
      BIG = 1.0E29
      M=N
      DO 10 K=1,N
        Z(K)=X(K)
   10 CONTINUE
      I=1
 20   CONTINUE
        K=150
        XMIN=BIG
        DO 40 J=1,M
C         find minimum value in array
          IF (XMIN.GT.Z(J)) THEN
            K=J
            XMIN=Z(J)
          END IF
 40     CONTINUE
        X(I)=Z(K)
        IF (K.NE.M) THEN
C         remove found minimum value from array
          IK=K+1
          DO 50 J=IK,M
            IJ=J-1
            Z(IJ)=Z(J)
 50       CONTINUE
        END IF
        M=M-1
        I=I+1
      IF (I.LE.N) GO TO 20
C
      RETURN
      END
C
C
C
      SUBROUTINE   RANK
     I                  (N,
     M                   X)
C
C     + + + PURPOSE + + +
C     Sorts an array in descending order.  Maximum size of the
C     array is 120.
C
C     + + + DUMMY ARGUMENTS + + +
      INTEGER   N
      REAL      X(120)
C
C     + + + ARGUMENT DEFINITIONS + + +
C
C     + + + LOCAL VARIABLES + + +
      REAL Z(120), SMALL, XMAX
      INTEGER   M,K,I,J,IK,IJ
C
C     + + + END SPECIFICATIONS + + +
C
      SMALL = -1.0E29
      M=N
      DO 10 K=1,N
        Z(K)=X(K)
   10 CONTINUE
      I=1
 20   CONTINUE
        K=150
        XMAX=SMALL
        DO 40 J=1,M
          IF (XMAX.LT.Z(J)) THEN
            K=J
            XMAX=Z(J)
          END IF
 40     CONTINUE
        X(I)=Z(K)
        IF (K.NE.M) THEN
          IK=K+1
          DO 50 J=IK,M
            IJ=J-1
            Z(IJ)=Z(J)
 50       CONTINUE
        END IF
        M=M-1
        I=I+1
      IF (I.LE.N) GO TO 20
C
      RETURN
      END
C
C
C
      SUBROUTINE   FILLP
     O                (PLUS)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   PLUS(27,35)
C
C     + + + ARGUMENT DEFINITION + + +
C     PLUS  -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   J, I
      REAL      PL(27,35)
C
C     + + + DATA INITIALIZATION + + +
C
      DATA  ( PL(1,J), J = 1, 35)
     #         /-3.71902,-3.50703,-3.29921,-3.09631,-2.89907,-2.70836,-2
     1.52507,-2.35015,-2.18448,-2.02891,-1.88410,-1.75053,-1.62838,-1.51
     2752,-1.41753,-1.32774,-1.24728,-1.17520,-1.11054,-1.05239,-0.99990
     3,-0.95234,-0.90908,-0.86956,-0.83333,-0.80000,-0.76923,-0.74074,-0
     4.71429,-0.68966,-0.66667,-0.64516,-0.62500,-0.60606,-0.58824/
C
      DATA  ( PL(2,J), J = 1, 35)
     #         /-3.29053,-3.12767,-2.96698,-2.80889,-2.65390,-2.50257,-2
     1.35549,-2.21328,-2.07661,-1.94611,-1.82241,-1.70603,-1.59738,-1.49
     2673,-1.40413,-1.31944,-1.24235,-1.17240,-1.10901,-1.05159,-0.99950
     3,-0.95215,-0.90899,-0.86952,-0.83331,-0.79999,-0.76923,-0.74074,-0
     4.71429,-0.68966,-0.66667,-0.64516,-0.62500,-0.60606,-0.58824/
C
      DATA  ( PL(3,J), J = 1, 35)
     #         /-3.09023,-2.94834,-2.80786,-2.66915,-2.53261,-2.39867,-2
     1.26780,-2.14053,-2.01739,-1.89894,-1.78572,-1.67825,-1.57695,-1.48
     2216,-1.39408,-1.31275,-1.23805,-1.16974,-1.10743,-1.05068,-0.99900
     3,-0.95188,-0.90885,-0.86945,-0.83328,-0.79998,-0.76922,-0.74074,-0
     4.71428,-0.68965,-0.66667,-0.64516,-0.62500,-0.60606,-0.58824/
C
      DATA  ( PL(4,J), J = 1, 35)
     #         /-2.57583,-2.48187,-2.38795,-2.29423,-2.20092,-2.10825,-2
     1.01644,-1.92580,-1.83660,-1.74919,-1.66390,-1.58110,-1.50114,-1.42
     2439,-1.35114,-1.28167,-1.21618,-1.15477,-1.09749,-1.04427,-0.99499
     3,-0.94945,-0.90742,-0.86863,-0.83283,-0.79973,-0.76909,-0.74067,-0
     4.71425,-0.68964,-0.66666,-0.64516,-0.62500,-0.60606,-0.58824/
C
      DATA  ( PL(5,J), J = 1, 35)
     #         /-2.32635,-2.25258,-2.17840,-2.10394,-2.02933,-1.95472,-1
     1.88029,-1.80621,-1.73271,-1.66001,-1.58838,-1.51808,-1.44942,-1.38
     2267,-1.31815,-1.25611,-1.19680,-1.14042,-1.08711,-1.03695,-0.98995
     3,-0.94607,-0.90521,-0.86723,-0.83196,-0.79921,-0.76878,-0.74049,-0
     4.71415,-0.68959,-0.66663,-0.64514,-0.62499,-0.60606,-0.58823/
C
      DATA  ( PL(6,J), J = 1, 35)
     #         /-2.05375,-1.99973,-1.94499,-1.88959,-1.83361,-1.77716,-1
     1.72033,-1.66325,-1.60604,-1.54886,-1.49188,-1.43529,-1.37929,-1.32
     2412,-1.26999,-1.21716,-1.16584,-1.11628,-1.11628,-1.02311,-0.97980
     3,-0.93878,-0.90009,-0.86371,-0.82959,-0.79765,-0.76779,-0.73987,-0
     4.71377,-0.68935,-0.66649,-0.64507,-0.62495,-0.60603,-0.58822/
C
      DATA  ( PL(7,J), J = 1, 35)
     #         /-1.95996,-1.91219,-1.86360,-1.81427,-1.76427,-1.71366,-1
     1.66253,-1.61099,-1.55914,-1.50712,-1.45507,-1.40314,-1.35153,-1.30
     2042,-1.25004,-1.20059,-1.15229,-1.10537,-1.06001,-1.01640,-0.97468
     3,-0.93495,-0.89728,-0.86169,-0.82817,-0.79667,-0.76712,-0.73943,-0
     4.71348,-0.68917,-0.66638,-0.64500,-0.62491,-0.60601,-0.58821/
C
      DATA  ( PL(8,J), J = 1, 35)
     #         /-1.75069,-1.71580,-1.67999,-1.64329,-1.60574,-1.56740,-1
     1.52830,-1.48852,-1.44813,-1.40720,-1.36584,-1.32414,-1.28225,-1.24
     2028,-1.19842,-1.15682,-1.11566,-1.07513,-1.03543,-0.99672,-0.95918
     3,-0.92295,-0.88814,-0.85486,-0.82315,-0.79306,-0.76456,-0.73765,-0
     4.71227,-0.68836,-0.66585,-0.64465,-0.62469,-0.60587,-0.58812/
C
      DATA  ( PL(9,J), J = 1, 35)
     #         /-1.64485,-1.61594,-1.58607,-1.55527,-1.52357,-1.49101,-1
     1.45762,-1.42345,-1.38855,-1.35299,-1.31684,-1.28019,-1.24313,-1.20
     2578,-1.16827,-1.13075,-1.09338,-1.05631,-1.01973,-0.98381,-0.94871
     3,-0.91458,-0.88156,-0.84976,-0.81927,-0.79015,-0.76242,-0.73610,-0
     4.71116,-0.68759,-0.66532,-0.64429,-0.62445,-0.60572,-0.58802/
C
      DATA  ( PL(10,J), J = 1, 35)
     #         /-1.28155,-1.27037,-1.25824,-1.24516,-1.23114,-1.21618,-1
     1.20028,-1.18347,-1.16574,-1.14712,-1.12762,-1.10726,-1.08608,-1.06
     2413,-1.04144,-1.01810,-0.99418,-0.96977,-0.94496,-0.91988,-0.89464
     3,-0.86938,-0.84422,-0.81929,-0.79472,-0.77062,-0.74709,-0.72422,-0
     4.70209,-0.68075,-0.66023,-0.64056,-0.62175,-0.60379,-0.58666/
C
      DATA  ( PL(11,J), J = 1, 35)
     #         /-0.84162,-0.84611,-0.84986,-0.85285,-0.85508,-0.85653,-0
     1.85718,-0.85703,-0.85607,-0.85426,-0.85161,-0.84809,-0.84369,-0.83
     2841,-0.83223,-0.82516,-0.81720,-0.80837,-0.79868,-0.78816,-0.77686
     3,-0.76482,-0.75211,-0.73880,-0.72495,-0.71067,-0.69602,-0.68111,-0
     4.66603,-0.65086,-0.63569,-0.62060,-0.60567,-0.59096,-0.57652/
C
      DATA  ( PL(12,J), J = 1, 35)
     #         /-0.52440,-0.53624,-0.54757,-0.55839,-0.56867,-0.57840,-0
     1.58757,-0.59615,-0.60412,-0.61146,-0.61815,-0.62415,-0.62944,-0.63
     2400,-0.63779,-0.64080,-0.64300,-0.64436,-0.64488,-0.64453,-0.64333
     3,-0.64125,-0.63833,-0.63456,-0.62999,-0.62463,-0.61854,-0.61176,-0
     4.60434,-0.59634,-0.58783,-0.57887,-0.56953,-0.55989,-0.55000/
C
      DATA  ( PL(13,J), J = 1, 35)
     #         /-0.25335,-0.26882,-0.28403,-0.29897,-0.31362,-0.32796,-0
     1.34198,-0.35565,-0.36889,-0.38186,-0.39434,-0.40638,-0.41794,-0.42
     2899,-0.43949,-0.44942,-0.45873,-0.46739,-0.47538,-0.48265,-0.48917
     3,-0.49494,-0.49991,-0.50409,-0.50744,-0.50999,-0.51171,-0.51263,-0
     4.51276,-0.51212,-0.51073,-0.50863,-0.50585,-0.50244,-0.49844/
C
      DATA  ( PL(14,J), J = 1, 35)
     #         /0.0,-0.01662,-0.03325,-0.04993,-0.06651,-0.08302,-0.0994
     15,-0.11578,-0.13199,-0.14807,-0.16397,-0.17968,-0.19517,-0.21040,-
     20.22535,-0.23996,-0.25422,-0.26808,-0.28150,-0.29443,-0.30685,-0.3
     31872,-0.32999,-0.34063,-0.35062,-0.35992,-0.36852,-0.37640,-0.3835
     43,-0.38991,-0.39554,-0.40041,-0.40454,-0.40792,-0.41058/
C
      DATA  ( PL(15,J), J = 1, 35)
     #         /0.25335,0.23763,0.22168,0.20552,0.18916,0.17261,0.15589,
     10.13901,0.12199,0.10486,0.08763,0.07032,0.05297,0.03560,0.01824,0.
     200092,-0.01631,-0.03344,-0.05040,-0.06718,-0.08371,-0.09997,-0.115
     390,-0.13148,-0.14665,-0.16138,-0.17564,-0.18939,-0.20259,-0.21523,
     4-0.22726,-0.23868,-0.24946,-0.25958,-0.26904/
C
      DATA  ( PL(16,J), J = 1, 35)
     #         /0.52440,0.51207,0.49927,0.48600,0.47228,0.45812,0.44352,
     10.42851,0.41309,0.39729,0.38111,0.36458,0.34772,0.33054,0.31307,0.
     229535,0.27740,0.25925,0.24094,0.22250,0.20397,0.18540,0.16682,0.14
     3827,0.12979,0.11143,0.09323,0.07523,0.05746,0.03997,0.02279,0.0059
     46,-0.01050,-0.02654,-0.04215/
C
      DATA  ( PL(17,J), J = 1, 35)
     #         /0.84162,0.83639,0.83044,0.82377,0.81638,0.80829,0.79950,
     10.79002,0.77986,0.76902,0.75752,0.74537,0.73257,0.71915,0.70512,0.
     269050,0.67532,0.65959,0.64335,0.62662,0.60944,0.59183,0.57383,0.55
     3549,0.53683,0.51789,0.49872,0.47934,0.45980,0.44015,0.42040,0.4006
     41,0.38081,0.36104,0.34133/
C
      DATA  ( PL(18,J), J = 1, 35)
     #         /1.28155,1.29178,1.30105,1.30936,1.31671,1.32309,1.32850,
     11.33294,1.33640,1.33889,1.34039,1.34092,1.34047,1.33904,1.33665,1.
     233330,1.32900,1.32376,1.31760,1.31054,1.30259,1.29377,1.28412,1.27
     3365,1.26240,1.25039,1.23766,1.22422,1.21013,1.19539,1.18006,1.1641
     46,1.14772,1.13078,1.11337/
C
      DATA  ( PL(19,J), J = 1, 35)
     #         /1.64485,1.67279,1.69971,1.72562,1.75048,1.77428,1.79701,
     11.81864,1.83916,1.85856,1.87683,1.89395,1.90992,1.92472,1.93836,1.
     295083,1.96213,1.97227,1.98124,1.98906,1.99573,2.00128,2.00570,2.00
     3903,2.01128,2.01247,2.01263,2.01177,2.00992,2.00710,2.00335,1.9986
     49,1.99314,1.98674,1.97951/
C
      DATA  ( PL(20,J), J = 1, 35)
     #         /1.75069,1.78462,1.81756,1.84949,1.88039,1.91022,1.93896,
     11.96660,1.99311,2.01848,2.04269,2.06573,2.08758,2.10823,2.12768,2.
     214591,2.16293,2.17873,2.19332,2.20670,2.21888,2.22986,2.23967,2.24
     3831,2.25581,2.26217,2.26743,2.27160,2.27470,2.27676,2.27780,2.2778
     45,2.27693,2.27506,2.27229/
C
      DATA  ( PL(21,J), J = 1, 35)
     #         /1.95996,2.00688,2.05290,2.09795,2.14202,2.18505,2.22702,
     12.26790,2.30764,2.34623,2.38364,2.41984,2.45482,2.48855,2.52102,2.
     255222,2.58214,2.61076,2.63810,2.66413,2.68888,2.71234,2.73451,2.75
     3541,2.77506,2.79345,2.81062,2.82658,2.84134,2.85492,2.86735,2.8786
     45,2.88884,2.89795,2.90599/
C
      DATA  ( PL(22,J), J = 1, 35)
     #         /2.05375,2.10697,2.15935,2.21081,2.26133,2.31084,2.35931,
     12.40670,2.45298,2.49811,2.54206,2.58480,2.62631,2.66657,2.70556,2.
     274325,2.77964,2.81472,2.84848,2.88091,2.91202,2.94181,2.97028,2.99
     3744,3.02330,3.04787,3.07116,3.09320,3.11399,3.13356,3.15193,3.1691
     41,3.18512,3.20000,3.21375/
C
      DATA  ( PL(23,J), J = 1, 35)
     #         /2.32635,2.39961,2.47226,2.54421,2.61539,2.68572,2.75514,
     12.82359,2.89101,2.95735,3.02256,3.08660,3.14944,3.21103,3.27134,3.
     233035,3.38804,3.44438,3.49935,3.55295,3.60517,3.65600,3.70543,3.75
     3347,3.80013,3.84540,3.88930,3.93183,3.97301,4.01286,4.05138,4.0885
     49,4.12452,4.15917,4.19257/
C
      DATA  ( PL(24,J), J = 1, 35)
     #         /2.57583,2.66965,2.76321,2.85636,2.94900,3.04102,3.13232,
     13.22281,3.31243,3.40109,3.48874,3.57530,3.66073,3.74497,3.82798,3.
     290973,3.99016,4.06926,4.14700,4.22336,4.29832,4.37186,4.44398,4.51
     3467,4.58393,4.65176,4.71815,4.78313,4.84669,4.90884,4.96959,5.0289
     47,5.08697,5.14362,5.19892/
C
      DATA  ( PL(25,J), J = 1, 35)
     #         /3.09023,3.23322,3.37703,3.52139,3.66608,3.81090,3.95567,
     14.10022,4.24439,4.38807,4.53112,4.67344,4.81492,4.95549,5.09505,5.
     223353,5.37087,5.50701,5.64190,5.77549,5.90776,6.03865,6.16816,6.29
     3626,6.42292,6.54814,6.67191,6.79421,6.91505,7.03443,7.15235,7.2688
     41,7.38382,7.49739,7.60953/
C
      DATA  ( PL(26,J), J = 1, 35)
     #         /3.29053,3.45513,3.62113,3.78820,3.95605,4.12443,4.29311,
     14.46189,4.63057,4.79899,4.96701,5.13449,5.30130,5.46735,5.63252,5.
     279673,5.95990,6.12196,6.28285,6.44251,6.60090,6.75798,6.91370,7.06
     3804,7.22098,7.37250,7.52258,7.67121,7.81839,7.96411,8.10836,8.2511
     45,8.39248,8.53236,8.67076/
C
      DATA  ( PL(27,J), J = 1, 35)
     #         /3.71902,3.93453,4.15301,4.37394,4.59687,4.82141,5.04718,
     15.27389,5.50124,5.72899,5.95691,6.18480,6.41249,6.63980,6.86661,7.
     209277,7.31818,7.54272,7.76632,7.98888,8.21034,8.43064,8.64971,8.86
     3753,9.08403,9.29920,9.51301,9.72543,9.93643,10.14602,10.35418,10.5
     46090,10.76618,10.97001,11.17239/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 100 I = 1, 27
        DO 150 J = 1, 35
          PLUS(I,J) = PL(I,J)
 150    CONTINUE
 100  CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE   FILLN
     O                (FNEG)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   FNEG(27,35)
C
C     + + + ARGUMENT DEFINITION + + +
C     FNEG   -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   J, I
      REAL      PL(27,35)
C
C     + + + DATA INITIALIZATIONS + + +
      DATA  ( PL(1,J), J = 1, 35)
     #         /-3.71902,-3.93453,-4.15301,-4.37394,-4.59687,-4.82141,-5
     1.04718,-5.27389,-5.50124,-5.72899,-5.95691,-6.18480,-6.41249,-6.63
     2980,-6.86661,-7.09277,-7.31818,-7.54272,-7.76632,-7.98888,-8.21034
     3,-8.43064,-8.64971,-8.86753,-9.08403,-9.29920,-9.51301,-9.72543,-9
     4.93643,-10.14602,-10.35418,-10.56090,-10.76618,-10.97001,-11.17239
     5/
C
      DATA  ( PL(2,J), J = 1, 35)
     #         /-3.29053,-3.45513,-3.62113,-3.78820,-3.95605,-4.12443,-4
     1.29311,-4.46189,-4.63057,-4.79899,-4.96701,-5.13449,-5.30130,-5.46
     2735,-5.63252,-5.79673,-5.95990,-6.12196,-6.28285,-6.44251,-6.60090
     3,-6.75798,-6.91370,-7.06804,-7.22098,-7.37250,-7.52258,-7.67121,-7
     4.81839,-7.96411,-8.10836,-8.25115,-8.39248,-8.53236,-8.67079/
C
      DATA  ( PL(3,J), J = 1, 35)
     #         /-3.09023,-3.23322,-3.37703,-3.52139,-3.66608,-3.81090,-3
     1.95567,-4.10022,-4.24439,-4.38807,-4.53112,-4.67344,-4.81492,-4.95
     2549,-5.09505,-5.23353,-5.37087,-5.50701,-5.64190,-5.77549,-5.90776
     3,-6.03865,-6.16816,-6.29626,-6.42292,-6.54814,-6.67191,-6.79421,-6
     4.91505,-7.03443,-7.15235,-7.26881,-7.38382,-7.49739,-7.60953/
C
      DATA  ( PL(4,J), J = 1, 35)
     #         /-2.57583,-2.66965,-2.76321,-2.85636,-2.94900,-3.04102,-3
     1.13232,-3.22281,-3.31243,-3.40109,-3.48874,-3.57530,-3.66073,-3.74
     2497,-3.82798,-3.90973,-3.99016,-4.06926,-4.14700,-4.22336,-4.29832
     3,-4.37186,-4.44398,-4.51467,-4.58393,-4.65176,-4.71815,-4.78313,-4
     4.84669,-4.90884,-4.96959,-5.02897,-5.08697,-5.14362,-5.19892/
C
      DATA  ( PL(5,J), J = 1, 35)
     #         /-2.32635,-2.39961,-2.47226,-2.54421,-2.61539,-2.68572,-2
     1.75514,-2.82359,-2.89101,-2.95735,-3.02256,-3.08660,-3.14944,-3.21
     2103,-3.27134,-3.33035,-3.38804,-3.44438,-3.49935,-3.55295,-3.60517
     3,-3.65600,-3.70543,-3.75347,-3.80013,-3.84540,-3.88930,-3.93183,-3
     4.97301,-4.01286,-4.05138,-4.08859,-4.12452,-4.15917,-4.19257/
C
      DATA  ( PL(6,J), J = 1, 35)
     #         /-2.05375,-2.10697,-2.15935,-2.21081,-2.26133,-2.31084,-2
     1.35931,-2.40670,-2.45298,-2.49811,-2.54206,-2.58480,-2.62631,-2.66
     2657,-2.70556,-2.74325,-2.77964,-2.81472,-2.84848,-2.88091,-2.91202
     3,-2.94181,-2.97028,-2.99744,-3.02330,-3.04787,-3.07116,-3.09320,-3
     4.11399,-3.13356,-3.15193,-3.16911,-3.18512,-3.20000,-3.21375/
C
      DATA  ( PL(7,J), J = 1, 35)
     #         /-1.95996,-2.00688,-2.05290,-2.09795,-2.14202,-2.18505,-2
     1.22702,-2.26790,-2.30764,-2.34623,-2.38364,-2.41984,-2.45482,-2.48
     2855,-2.52102,-2.55222,-2.58214,-2.61076,-2.63810,-2.66413,-2.68888
     3,-2.71234,-2.73451,-2.75541,-2.77506,-2.79345,-2.81062,-2.82658,-2
     4.84134,-2.85492,-2.86735,-2.87865,-2.88884,-2.89795,-2.90599/
C
      DATA  ( PL(8,J), J = 1, 35)
     #         /-1.75069,-1.78462,-1.81756,-1.84949,-1.88039,-1.91022,-1
     1.93896,-1.96660,-1.99311,-2.01848,-2.04269,-2.06573,-2.08758,-2.10
     2823,-2.12768,-2.14591,-2.16293,-2.17873,-2.19332,-2.20670,-2.21888
     3,-2.22986,-2.23967,-2.24831,-2.25581,-2.26217,-2.26743,-2.27160,-2
     4.27470,-2.27676,-2.27780,-2.27785,-2.27693,-2.27506,-2.27229/
C
      DATA  ( PL(9,J), J = 1, 35)
     #         /-1.64485,-1.67279,-1.69971,-1.72562,-1.75048,-1.77428,-1
     1.79701,-1.81864,-1.83916,-1.85856,-1.87683,-1.89395,-1.90992,-1.92
     2472,-1.93836,-1.95083,-1.96213,-1.97227,-1.98124,-1.98906,-1.99573
     3,-2.00128,-2.00570,-2.00903,-2.01128,-2.01247,-2.01263,-2.01177,-2
     4.00992,-2.00710,-2.00335,-1.99869,-1.99314,-1.98674,-1.97951/
C
      DATA  ( PL(10,J), J = 1, 35)
     #         /-1.28155,-1.29178,-1.30105,-1.30936,-1.31671,-1.32309,-1
     1.32850,-1.33294,-1.33640,-1.33889,-1.34039,-1.34092,-1.34047,-1.33
     2904,-1.33665,-1.33330,-1.32900,-1.32376,-1.31760,-1.31054,-1.30259
     3,-1.29377,-1.28412,-1.27365,-1.26240,-1.25039,-1.23766,-1.22422,-1
     4.21013,-1.19539,-1.18006,-1.16416,-1.14772,-1.13078,-1.11337/
C
      DATA  ( PL(11,J), J = 1, 35)
     #         /-0.84162,-0.83639,-0.83044,-0.82377,-0.81638,-0.80829,-0
     1.79950,-0.79002,-0.77986,-0.76902,-0.75752,-0.74537,-0.73257,-0.71
     2915,-0.70512,-0.69050,-0.67532,-0.65959,-0.64335,-0.62662,-0.60944
     3,-0.59183,-0.57383,-0.55549,-0.53683,-0.51789,-0.49872,-0.47934,-0
     4.45980,-0.44015,-0.42040,-0.40061,-0.38081,-0.36104,-0.34133/
C
      DATA  ( PL(12,J), J = 1, 35)
     #         /-0.52440,-0.51207,-0.49927,-0.48600,-0.47228,-0.45812,-0
     1.44352,-0.42851,-0.41309,-0.39729,-0.38111,-0.36458,-0.34772,-0.33
     2054,-0.31307,-0.29535,-0.27740,-0.25925,-0.24094,-0.22250,-0.20397
     3,-0.18540,-0.16682,-0.14827,-0.12979,-0.11143,-0.09323,-0.07523,-0
     4.05746,-0.03997,-0.02279,-0.00596,0.01050,0.02654,0.04215/
C
      DATA  ( PL(13,J), J = 1, 35)
     #         /-0.25335,-0.23763,-0.22168,-0.20552,-0.18916,-0.17261,-0
     1.15589,-0.13901,-0.12199,-0.10486,-0.08763,-0.07032,-0.05297,-0.03
     2560,-0.01824,-0.00092,0.01631,0.03340,0.05040,0.06718,0.08371,0.09
     3997,0.11590,0.13148,0.14665,0.16138,0.17564,0.18939,0.20259,0.2152
     43,0.22726,0.23868,0.24946,0.25958,0.26904/
C
      DATA  ( PL(14,J), J = 1, 35)
     #         /-0.0,0.01662,0.03325,0.04993,0.06651,0.08302,0.09945,0.1
     11578,0.13199,0.14807,0.16397,0.17968,0.19517,0.21040,0.22535,0.239
     296,0.25422,0.26808,0.28150,0.29443,0.30685,0.31872,0.32999,0.34063
     3,0.35062,0.35992,0.36852,0.37640,0.38353,0.38991,0.39554,0.40041,0
     4.40454,0.40792,0.41058/
C
      DATA  ( PL(15,J), J = 1, 35)
     #         /0.25335,0.26882,0.28403,0.29897,0.31362,0.32796,0.34198,
     10.35565,0.36889,0.38186,0.39434,0.40638,0.41794,0.42899,0.43949,0.
     244942,0.45873,0.46739,0.47538,0.48265,0.48917,0.49494,0.49991,0.50
     3409,0.50744,0.50999,0.51171,0.51263,0.51276,0.51212,0.51073,0.5086
     43,0.50585,0.50244,0.49844/
C
      DATA  ( PL(16,J), J = 1, 35)
     #         /0.52440,0.53624,0.54757,0.55839,0.56867,0.57840,0.58757,
     10.59615,0.60412,0.61146,0.61815,0.62415,0.62944,0.63400,0.63779,0.
     264080,0.64300,0.64436,0.64488,0.64453,0.64333,0.64125,0.63833,0.63
     3456,0.62999,0.62463,0.61854,0.61176,0.60434,0.59634,0.58783,0.5788
     47,0.56953,0.55989,0.55000/
C
      DATA  ( PL(17,J), J = 1, 35)
     #         /0.84162,0.84611,0.84986,0.85285,0.85508,0.85653,0.85718,
     10.85703,0.85607,0.85426,0.85161,0.84809,0.84369,0.83841,0.83223,0.
     282516,0.81720,0.80837,0.79868,0.78816,0.77686,0.76482,0.75211,0.73
     3880,0.72495,0.71067,0.69602,0.68111,0.66603,0.65086,0.63569,0.6206
     40,0.60567,0.59096,0.57652/
C
      DATA  ( PL(18,J), J = 1, 35)
     #         /1.28155,1.27037,1.25824,1.24516,1.23114,1.21618,1.20028,
     11.18347,1.16574,1.14712,1.12762,1.10726,1.08608,1.06413,1.04144,1.
     201810,0.99418,0.96977,0.94496,0.91988,0.89464,0.86938,0.84422,0.81
     3929,0.79472,0.77062,0.74709,0.72422,0.70209,0.68075,0.66023,0.6405
     46,0.62175,0.60379,0.58666/
C
      DATA  ( PL(19,J), J = 1, 35)
     #         /1.64485,1.61594,1.58607,1.55527,1.52357,1.49101,1.45762,
     11.42345,1.38855,1.35299,1.31684,1.28019,1.24313,1.20578,1.16827,1.
     213075,1.09338,1.05631,1.01973,0.98381,0.94871,0.91458,0.88156,0.84
     3976,0.81927,0.79015,0.76242,0.73610,0.71116,0.68759,0.66532,0.6442
     49,0.62445,0.60572,0.58802/
C
      DATA  ( PL(20,J), J = 1, 35)
     #         /1.75069,1.71580,1.67999,1.64329,1.60574,1.56740,1.52830,
     11.48852,1.44813,1.40720,1.36584,1.32414,1.28225,1.24028,1.19842,1.
     215682,1.11566,1.07513,1.03543,0.99672,0.95918,0.92295,0.88814,0.85
     3486,0.82315,0.79306,0.76456,0.73765,0.71227,0.68336,0.66585,0.6446
     45,0.62469,0.60587,0.58812/
C
      DATA  ( PL(21,J), J = 1, 35)
     #         /1.95996,1.91219,1.86360,1.81427,1.76427,1.71366,1.66253,
     11.61099,1.55914,1.50712,1.45507,1.40314,1.35153,1.30042,1.25004,1.
     220059,1.15229,1.10537,1.06001,1.01640,0.97468,0.93495,0.89728,0.86
     3169,0.82817,0.79667,0.76712,0.73943,0.71348,0.68917,0.66638,0.6450
     40,0.62491,0.60601,0.58821/
C
      DATA  ( PL(22,J), J = 1, 35)
     #         /2.05375,1.99973,1.94499,1.88959,1.83361,1.77716,1.72033,
     11.66325,1.60604,1.54886,1.49188,1.43529,1.37929,1.32412,1.26999,1.
     221716,1.16584,1.11628,1.06864,1.02311,0.97980,0.93878,0.90009,0.86
     3371,0.82959,0.79765,0.76779,0.73987,0.71377,0.68935,0.66649,0.6450
     47,0.62495,0.60603,0.58822/
C
      DATA  ( PL(23,J), J = 1, 35)
     #         /2.32635,2.25258,2.17840,2.10394,2.02933,1.95472,1.88029,
     11.80621,1.73271,1.66001,1.58838,1.51808,1.44942,1.38267,1.31815,1.
     225611,1.19680,1.14042,1.08711,1.03695,0.98995,0.94607,0.90521,0.86
     3723,0.83196,0.79921,0.76878,0.74049,0.71415,0.68959,0.66663,0.6451
     44,0.62499,0.60606,0.58823/
C
      DATA  ( PL(24,J), J = 1, 35)
     #         /2.57583,2.48187,2.38795,2.29423,2.20092,2.10825,2.01644,
     11.92580,1.83660,1.74919,1.66390,1.58110,1.50114,1.42439,1.35114,1.
     228167,1.21618,1.15477,1.09749,1.04427,0.99499,0.94945,0.90742,0.86
     3863,0.83283,0.79973,0.76909,0.74067,0.71425,0.68964,0.66666,0.6451
     46,0.62500,0.60606,0.58824/
C
      DATA  ( PL(25,J), J = 1, 35)
     #         /3.09023,2.94834,2.80786,2.66915,2.53261,2.39867,2.26780,
     12.14053,2.01739,1.89894,1.78572,1.67825,1.57695,1.48216,1.39408,1.
     231275,1.23805,1.16974,1.10743,1.05068,0.99900,0.95188,0.90885,0.86
     3945,0.83328,0.79998,0.76922,0.74074,0.71428,0.68965,0.66667,0.6451
     46,0.62500,0.60606,0.58824/
C
      DATA  ( PL(26,J), J = 1, 35)
     #         /3.29053,3.12767,2.96698,2.80889,2.65390,2.50257,2.35549,
     12.21328,2.07661,1.94611,1.82241,1.70603,1.59738,1.49673,1.40413,1.
     231944,1.24235,1.17240,1.10901,1.05159,0.99950,0.95215,0.90899,0.86
     3952,0.83331,0.79999,0.76923,0.74074,0.71429,0.68966,0.66667,0.6451
     46,0.62500,0.60606,0.58824/
C
      DATA  ( PL(27,J), J = 1, 35)
     #         /3.71902,3.50703,3.29921,3.09631,2.89907,2.70836,2.52507,
     12.35015,2.18448,2.02891,1.88410,1.75053,1.62838,1.51752,1.41753,1.
     232774,1.24728,1.17520,1.11054,1.05239,0.99990,0.95234,0.90908,0.86
     3956,0.83333,0.80000,0.76923,0.74074,0.71429,0.68966,0.66667,0.6451
     46,0.62500,0.60606,0.58824/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 150 I = 1, 27
        DO 100 J = 1, 35
          FNEG(I,J) = PL(I,J)
 100    CONTINUE
 150  CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE   FILLGN
     O                (GN)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   GN(35)
C
C     + + + ARGUMENT DEFINITION + + +
C     GN    -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I
      REAL      GK(35)
C
C     + + + DATA INITIALIZATION + + +
      DATA GK/0.0,-0.1,-0.2,-0.3,-0.4,-0.5,-0.6,-0.7,-0.8,-0.9,-1.0,-1.1
     1,-1.2,-1.3,-1.4,-1.5,-1.6,-1.7,-1.8,-1.9,-2.0,-2.1,-2.2,-2.3,-2.4,
     2-2.5,-2.6,-2.7,-2.8,-2.9,-3.0,-3.1,-3.2,-3.3,-3.4/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 10 I=1,35
        GN(I)=GK(I)
   10 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE   FILLGP
     O                (GP)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   GP(35)
C
C     + + + ARGUMENT DEFINITION + + +
C     GP    -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I
      REAL      GK(35)
C
C     + + + DATA INITIALIZATION + + +
      DATA GK/0.0,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.9,1.0,1.1,1.2,1.3,1.
     14,1.5,1.6,1.7,1.8,1.9,2.0,2.1,2.2,2.3,2.4,2.5,2.6,2.7,2.8,2.9,3.0,
     23.1,3.2,3.3,3.4/
C
      DO 10 I=1,35
        GP(I)=GK(I)
   10 CONTINUE
C
      RETURN
      END
C
C
C
      SUBROUTINE   INTERS
     I                 (SKEW, PLUS, GP,
     O                  FK, K)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   PLUS(27,35), FK(27), GP(35), SKEW
      INTEGER   K
C
C     + + + ARGUMENT DEFINITION + + +
C     PLUS  -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I, IP, J
      REAL M
C
C     + + + END SPECIFICATIONS + + +
C
      K = 1
      I = 0
 100  CONTINUE
        I = I + 1
        IP=I+1
        IF (GP(I) .LE. SKEW  .AND.  SKEW .LT. GP(IP)) THEN
          K=0
          M=(SKEW-GP(I))/(GP(IP)-GP(I))
          DO 110 J=1,27
            FK(J)=PLUS(J,I)+M*(PLUS(J,IP)-PLUS(J,I))
 110      CONTINUE
        END IF
      IF (I .LT. 34  .AND.  K .NE. 0) GO TO 100
C
      RETURN
      END
C
C
C
      SUBROUTINE   INTERN
     I                 (SKEW, FNEG, GN,
     O                  FK, K)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   FNEG(27,35), GN(35), FK(27), SKEW
      INTEGER   K
C
C     + + + ARGUMENT DEFINITION + + +
C     SKEW  -
C     FNEG  -
C     GN     -
C     FK     -
C     K      -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I, IP, J
      REAL M
C
C     + + + END SPECIFICATIONS + + +
C
      K = 1
      I = 0
 100  CONTINUE
        I = I + 1
        IP = I + 1
        IF (GN(I) .GE. SKEW  .AND.  SKEW .GT. GN(IP)) THEN
          K = 0
          M = ( SKEW - GN(I) ) / ( GN(IP) - GN(I) )
          DO 110 J = 1, 27
            FK(J)=FNEG(J,I)+M*(FNEG(J,IP)-FNEG(J,I))
 110      CONTINUE
        END IF
      IF (I .LT. 34  .AND.  K .NE. 0) GO TO 100
C
      RETURN
      END
C
C
C
      SUBROUTINE   FILLPL
     O                 (SP)
C
C     + + + PURPOSE + + +
C     This routine
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   SP(27)
C
C     + + + ARGUMENT DEFINITION + + +
C     SP    -
C
C     + + + LOCAL VARIABLES + + +
      INTEGER   I
      REAL      X(27)
C
C     + + + DATA INITIALIZATION + + +
      DATA X/0.9999,0.9995,0.999,0.995,0.99,0.98,0.975,0.96,0.95,0.9,0.8
     1,0.7,0.6,0.5,0.4,0.3,0.2,0.1,0.05,0.04,0.025,0.02,0.01,0.005,0.001
     2,0.0005,0.0001/
C
C     + + + END SPECIFICATIONS + + +
C
      DO 10 I=1,27
        SP(I)=X(I)
   10 CONTINUE
C
      RETURN
      END
C
C
C
C
      SUBROUTINE   CPA193
     I                  (XIN,N,N0,N1,
     O                   XOUT)
C
C     + + + PURPOSE + + +
C  CONDITIONAL PROBABILITY ADJUSTMENT (CPA) -- VERSION A193 (WATSTORE)
C
C  NOTE -- USES OLD-STYLE HARTER TABLES WITH 27 QUANTILES. (A193)
C
C  CONVERTS A CONDITIONAL PEARSON TYPE III DISTRIBUTION BASED ON
C  A CENSORED SAMPLE (WITH N0,N1 ITEMS CENSORED FROM
C  BOTTOM AND TOP OF A SAMPLE OF TOTAL SIZE N) INTO AN EQUIVALENT
C  UNCONDITIONAL DISTRIBUTION (WHICH IS NOT NECESSARILY OF PEARSON
C  TYPE III).
C
C  THE INPUT CONDITIONAL DISTRIBUTION IS SPECIFIED AS AN INPUT VECTOR XI
C  CONTAINING QUANTILES BASED ON THE CENSORED-SAMPLE MEAN, STD.DEVIATION
C  AND SKEW (XIN = MEAN + STD.DEV * HARTER.K.VALUE).   THE INPUT QUANTIL
C  CORRESPOND TO STANDARD HARTER TABULAR CUMULATIVE (NONEXCEEDANCE) PROB
C
C  THE UNCONDITIONAL DISTRIBUTION IS RETURNED AS A VECTOR OF CPA-ADJUSTE
C  QUANTILES CORRESPONDING TO THE SAME STANDARD CUM. PROBABILITIES
C  TABULATED IN HARTER'S TABLES.  IF ANY TABULAR PCUM IS OUTSIDE
C  THE RANGE OF PROBABILITIES DEFINED BY THE CENSORED SAMPLE (I.E.,
C  IF PCUM.LT.N0/N .OR. .GT.1-N1/N), THEN A VALUE OF - OR + INFINITY
C  (I.E., -+1.01E31)  IS RETURNED.  (THIS IS DONE BECAUSE THE AVAIL-
C  ABLE INFORMATION DEFINES THE.)
C
C  PARAMETERS --
C  XIN   -(INPUT)- VECTOR (DIM 27) OF CONDITIONAL-DISTRIBUTION QUANTILES
C                  BASED ON CENSORED SAMPLE
C  N     -(INPUT)- TOTAL SAMPLE SIZE
C  N0    -(INPUT)- NUMBER OF ITEMS CENSORED OFF LOW END OF SAMPLE
C  N1    -(INPUT)- NUMBER OF ITEMS CENSORED OFF TOP ....
C  XOUT  -(OUTPUT)- VECTOR (DIMENSION 27) OF CPA-ADJUSTED QUANTILES
C
C  METHOD --
C  FOR X-VALUES BETWEEN CENSOR-LIMITS X0,X1, THE TOTAL-PROBABILITY
C  THEOREM STATES THAT --
C      PROB(RV.X .LE. X) = PROB(RV.X .LE. X, GIVEN RV.X W/IN X0,X1)
C                            * (N-N0-N1)/N   +   N0/N
C  THUS, UNCONDITIONAL QUANTILES AT PROBABILITY PCUM ARE FOUND BY LOOKUP
C  IN THE CONDITIONAL DISTRIBUTION AT PROBABILITY
C        PPRIME = (PCUM - N0/N) / (N-N0-N1)/N
C
C
C    WKIRBY, SWB  11/85.
C
C
C     + + + DUMMY ARGUMENTS + + +
      REAL   XIN(27), XOUT(27)
      INTEGER   N, N0, N1
C
C     + + + ARGUMENT DEFINITION + + +
C     XIN    -
C     N      -
C     N0     -
C     N1     -
C     XOUT   -
C
C     + + + LOCAL VARAIBLES + + +
      REAL   PROB(27), PPRIME
      INTEGER   I
C
C     + + + FUNCTIONS + + +
      REAL   HARTAK
C
C     + + + EXTERNALS + + +
      EXTERNAL   HARTAK
C
C     + +  DATA INITIALIZATIONS + + +
C     HARTER TABULAR PROBABILITIES --  (OLD OLD A193 27-QUANTILE-VERSION)
      DATA PROB     /   0.00010,
     #   0.00050,  0.00100,            0.00500,  0.01000,  0.02000,
     #   0.02500,  0.04000,  0.05000,  0.10000,  0.20000,  0.30000,
     #   0.40000,            0.50000,            0.60000,  0.70000,
     #   0.80000,  0.90000,  0.95000,  0.96000,  0.97500,  0.98000,
     #   0.99000,  0.99500,            0.99900,  0.99950,  0.99990 /
C
C     + + + END SPECIFICATIONS + + +
C
      DO 10 I = 1,27
        PPRIME = (N*PROB(I)-N0)/(N-N0-N1)
        XOUT(I) = HARTAK(PPRIME, XIN)
  10  CONTINUE
C
      RETURN
      END
