c file:     fv3vars.h
c update:   12:45 fri 9-sep-1994.
c
c ---------------------------------------------------------------------------
c Gnspecies .le. maxspecies;
c jspecies = 1, ..., Gnspecies;
c jage = 1 .. Xmaximum_age(jspecies);  Xmaximum_age(jspecies) .le. maxage
c
c qq_* :: variable age-dependent information array; example
c         Qq_wgamma(jage=1,jspecies=1) does not necessarily contains the info
c                                     for age=1, species = 1
c
c vv_* :: static age-dependent information array; example
c         Vv_growth_model(jage=1,jspecies=1) will always contain the info for
c                                            species=1, age=1.
c
c ---------------------------------------------------------------------------
c
c Ux(mp3)                           temporary storage
c Uy(mp3)
c
c ---------------------------------------------------------------------------
c >>>>> these arrays should be accessed by year class;
c       jage = 1 .. Xmaximum_age(jspecies)
c       (to save space: ja == jage, js == jspecies)
c
c the physiological parameters are "species" dependent;
c Vv_iniwt, plfish, ... are year class dependent;
c Qq_wgamma, qq_eps1-2, Qq_gmax, ... are fish dependent;
c
c ------------------------------
c === THIS INFORMATION IS STATIC, e.g., Vv_growth_model(1,1) will always contain
c                                 the info for age=1, species=1.
c
c Vv_growth_model(ja,js)   fish growth model
c                             values: tlinear, tallometric, tholling, tclearance
c Vv_functional_response(ja,js)       if tallometric or tholling, func_resp is the ratio
c                             of realized ingestion to maximal ingestion
c                             (i.e., func_resp = c / cmax).
c Vv_pval(maxfpar,ja,js)
c     because, during input, year class parameters are stored here;
c
c Vv_ptyp(maxfpar,ja,js)  fishpar_erase;
c                          if Vv_ptyp (...) == TRUE then
c                             set Vv_pval (...) = rnoval;
c                             the idea is to place in this position
c                                 the database value of the parameter;
c                          Vv_ptyp is set to "database" or tdatabase;
c
c Vv_plfunc(ja,js)
c Vv_iniwt(ja,js)             initial wt for the year class
c Vv_inicf(maxchem,ja,js)     initial concentration of chem in fish
c vv_cfood(maxchem,ja,js)     initial concentration of chem in food, used
c                             with "tlaboratory"
c vv_bmf (maxchem,ja,js)      initial vv_bmf in prey, used with "tfood_chain" or
c                             "tlaboratory"
c
c ----------------------------------
c === THIS INFORMATION IS NOT STATIC
c
c Qq_fish_age(jage,jspecies)  age in integer years of the fish
c
c Qq_nxy(jage,jspecies)                       number of stored plotting points
c Qq_iterno(jage,jspecies)                     iteration number
c Qq_iprint(jage,jspecies)                     (integer) print flag
c Qq_hgamma(mp3,jage,jspecies)                 fish growth rate;
c Qq_tcal(mp3,jage,jspecies)                   time
c Qq_wcal(mp3,jage,jspecies)                   weight
c Qq_cfcal(mp3,maxchem,jage,jspecies)          concentration in fish at "Qq_tcal"
c Qq_hactvt(mp3,jage,jspecies)                 activity
c Qq_new_day(jage,jspecies)                    used to determine if we are at dawn;
c Qq_max_activity(jage,jspecies)
c qq_maxcf(maxchem,jage,jspecies)
c
c Qq_cp(maxchem,jage,jspecies)
c Qq_wgamma(jage,jspecies), Qq_phi(jage,jspecies), Qq_gmax(jage,jspecies)
c Qq_alpha1(jage,jspecies), Qq_alpha2(jage,jspecies)
c Qq_epsl1(jage,jspecies), Qq_epsl2(jage,jspecies)
c Qq_mu(jage,jspecies)
c Qq_sgill(jage,jspecies)
c
c Qq_igamma(jage,jspecies), Qq_iingest(jage,jspecies)
c Qq_iassim(jage,jspecies), Qq_iegest(jage,jspecies)
c Qq_iexcret(jage,jspecies), Qq_irespir(jage,jspecies), Qq_isda(jage,jspecies)
c Qq_lenfish(jage,jspecies)
c Qq_wingest(jage,jspecies), Qq_wassim(jage,jspecies), Qq_wegest(jage,jspecies)
c Qq_wrespir(jage,jspecies), Qq_wsda(jage,jspecies), Qq_wexcret(jage,jspecies)
c Qq_cfj(maxchem,jage,jspecies)
c Qq_tjgilup(maxchem,jage,jspecies), Qq_tjgilex(maxchem,jage,jspecies)
c Qq_tjgutup(maxchem,jage,jspecies), Qq_tjgutex(maxchem,jage,jspecies)
c Qq_jgilup(maxchem,jage,jspecies), Qq_jgilex(maxchem,jage,jspecies)
c Qq_jgutup(maxchem,jage,jspecies), Qq_jgutex(maxchem,jage,jspecies)
c Qq_kf(maxchem,jage,jspecies)
c Qq_pa(jage,jspecies)
c Qq_kw(maxchem,jage,jspecies)
c
c Qq_death_day(jage,jspecies)
c Qq_fish_alive(jage,jspecies)
c
c ---------------------------------------------------------------------------
c >>>>> these arrays should be accessed by jspecies = 1, ..., Gnspecies
c       Gnspecies .le. maxspecies;
c
c Xmaximum_age(jspecies)            number of year_classes
c Lc50func(maxchem,jspecies)        concentration to obtain 50% mortality
c Lc50par(maxpar,maxchem,jspecies)  parameters for "Lc50func"
c Fish_la50(jspecies)               lethal activity
c Spplab(jspecies)
c Famlab(jspecies)
c Ecolab(jspecies)
c Activegill(jspecies)              fraction of gill surface area used
c                                      for exchange
c Data_t(jspecies)
c Data_c(jspecies)
c Data_w(jspecies)
c Nobs(jspecies)
c Col_t(jspecies)
c Col_w(jspecies)
c Col_c(jspecies)
c Tobs(maxobs,jspecies)
c Wobs(maxobs,jspecies)
c Cfobs(maxobs,maxchem,jspecies)
c
c ---------------------------------------------------------------------------
c >>> other variables
c Hcw(mp3,maxchem)                  water concentration
c Twmean
c Cwmean(maxchem)
c xsave_status                      "to save" status;
c xcurrent_fish                     fish being integrated
c
c tlaboratory
c  Tank_flow, Tank_volume, Tank_nfish, Tank_cw(maxchem)
c  Food_chem_func
c  Food_chem_conc(maxchem), Food_bmf(maxchem)
c  Food_pl
c
