        subroutine M2FLUX(Y)
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'LOCAL1.INC'
      dimension Y(KOUNT,KCHEM)
      double precision Y
      real BIO, CHE, GNDOUT, HAFLS, HAFLT, HAFLW, PERCET,
     &SOCACU, SOCBIO(2), SOCCHE, SOCDP, SOCHYD, SOCOUT, SOCOX,
     &SOCPHO, SOCSOX, SOCVOL, TOTBIO, SOCRED, TOTFLX, VOL
      real SURWAT, TEMP, TLOCAL(4), PCTWAT, PCTSED
      integer I, J, K2, III(2), IV, VRAIL
      logical ACTION
      character KOUT*2, NAMTIM(4)*7
      data TLOCAL/1.0,24.0,730.5,8766./
      data NAMTIM/' hours.','  days.','months.',' years.'/
      III(1) = VRAIL(ECONAM)
      do 160 K2 = 1, KCHEM
         III(2) = VRAIL(CHEMNA(1,K2))
         write (KOUT,5010) K2
         if (KOUT(1:1).eq.' ') KOUT(1:1) = '0'
         write(RPTLUN(MACHNO),5000) VERSN,MODEG,(ECONAM(IV),IV=1,III(1))
         write(RPTLUN(MACHNO),5020) (CHEMNA(IV,K2),IV=1,III(2))
         write(RPTLUN(MACHNO),5030)
5000  format ('1','Exposure Analysis Modeling System -- EXAMS Version ',
     &F4.2,', Mode',I2/' Ecosystem: ',50A1)
5010     format (I2)
5020     format (' Chemical:  ',50A1)
5030     format (1X,63('-'))
         I = int(TENDG)
         write (RPTLUN(MACHNO),5040) KOUT,I,NAMTIM(TCODEG)
5040     format (' Table 18.',A2,'.  Sensitivity analysis: after',I5,1X,
     &      A7)
         write (RPTLUN(MACHNO),5220)
         write (RPTLUN(MACHNO),5050)
5050  format (5X,'Current Value',11X,'Mass Flux',4X,'% of Total',2X,'Hal
     &f-Life*')
         SOCOUT = 0.0
         GNDOUT = 0.0
         SURWAT = 0.0
         do 120 J = 1, KOUNT
            TEMP = 1.0E-06*Y(J,K2)*EXPOKL(J,K2)
            SOCOUT = SOCOUT+TEMP
            if (TYPEG(J).eq.'B'.and.TYPEG(J-1).eq.'B') go to 100
            SURWAT = SURWAT+TEMP
            go to 110
100         continue
            GNDOUT = GNDOUT+TEMP
110         continue
120      continue
         SOCVOL = 0.0
         SOCCHE = 0.0
         SOCHYD = 0.0
         SOCOX = 0.0
         SOCDP = 0.0
         SOCSOX = 0.0
         SOCBIO(1) = 0.0
         SOCBIO(2) = 0.0
         SOCRED = 0.0
         do 130 J = 1, KOUNT
            VOL = VOLKL(J,K2)*Y(J,K2)
            SOCVOL = SOCVOL+1.0E-06*VOL*WATVOL(J)
            CHE = HYDRKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCHYD = SOCHYD+1.0E-06*CHE*WATVOL(J)
            CHE = OXIDKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCOX = SOCOX+1.0E-06*CHE*WATVOL(J)
            CHE = PHOTKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCDP = SOCDP+1.0E-06*CHE*WATVOL(J)
            CHE = S1O2KL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCSOX = SOCSOX+1.E-06*CHE*WATVOL(J)
            CHE = REDKL(J,K2)*Y(J,K2)
            SOCCHE = SOCCHE+CHE*WATVOL(J)
            SOCRED = SOCRED+1.0E-06*CHE*WATVOL(J)
            if (TYPEG(J).eq.'B') then
               BIO = Y(J,K2)*BIOLKL(J,K2)
               SOCBIO(2) = SOCBIO(2)+1.E-06*BIO*WATVOL(J)
            else
               BIO = Y(J,K2)*BIOLKL(J,K2)
               SOCBIO(1) = SOCBIO(1)+1.0E-06*BIO*WATVOL(J)
            endif
130      continue
         SOCCHE = SOCCHE*1.0E-06
         TOTFLX = SOCOUT+SOCVOL+SOCBIO(1)+SOCBIO(2)+SOCCHE
         HAFLT = 0.
         if (TOTFLX.ne.0.0) HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/TOTFLX
         write (RPTLUN(MACHNO),5060) NAMTIM(TCODEG),NAMTIM(TCODEG)
5060     format (6X,'by Process',14X,'Kg/',A5,7X,'Flux',7X,A6)
         write (RPTLUN(MACHNO),5070)
5070     format (4X,15('-'),10X,10('-'),3X,10('-'),2X,10('-'))
         TFACTR = TLOCAL(TCODEG)
         if (TCODEG.eq.1) go to 140
         SOCHYD = SOCHYD*TFACTR
         SOCOX = SOCOX*TFACTR
         SOCDP = SOCDP*TFACTR
         SOCSOX = SOCSOX*TFACTR
         SOCBIO(1) = SOCBIO(1)*TFACTR
         SOCBIO(2) = SOCBIO(2)*TFACTR
         SOCRED = SOCRED*TFACTR
         SOCVOL = SOCVOL*TFACTR
         SOCOUT = SOCOUT*TFACTR
         SOCCHE = SOCCHE*TFACTR
         SOCACU = SOCACU*TFACTR
         GNDOUT = GNDOUT*TFACTR
         SURWAT = SURWAT*TFACTR
         TOTFLX = TOTFLX*TFACTR
140      continue
         if (TOTFLX.eq.0.0) then
            TOTFLX = 1.0
            ACTION = .false.
         else
            ACTION = .true.
         endif
         if (SOCHYD.eq.0.0) then
            write (RPTLUN(MACHNO),5080)
         else
            PERCET = 100.*SOCHYD/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCHYD
            write (RPTLUN(MACHNO),5080) SOCHYD,PERCET,HAFLT
         endif
5080     format (' Hydrolysis',:,17X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCRED.eq.0.0) then
            write (RPTLUN(MACHNO),5090)
         else
            PERCET = 100.*SOCRED/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCRED
            write (RPTLUN(MACHNO),5090) SOCRED,PERCET,HAFLT
         endif
5090     format (' Reduction',:,18X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCOX.eq.0.0) then
            write (RPTLUN(MACHNO),5100)
         else
            PERCET = 100.*SOCOX/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCOX
            write (RPTLUN(MACHNO),5100) SOCOX,PERCET,HAFLT
         endif
5100    format (' Radical oxidation',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         SOCPHO = SOCDP
         if (SOCPHO.eq.0.0) then
            write (RPTLUN(MACHNO),5110)
         else
            PERCET = 100.*SOCPHO/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCPHO
            write (RPTLUN(MACHNO),5110) SOCPHO,PERCET,HAFLT
         endif
5110     format (' Direct photolysis',:,10X,1PG11.4,4X,0PF6.2,4X,1PG11.4
     &      )
         if (SOCSOX.eq.0.0) then
            write (RPTLUN(MACHNO),5120)
         else
            PERCET = 100.*SOCSOX/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCSOX
            write (RPTLUN(MACHNO),5120) SOCSOX,PERCET,HAFLT
         endif
5120     format (' Singlet oxygen oxidation',:,3X,1PG11.4,4X,0PF6.2,4X, 
     &      1PG11.4)
         CHEMPC(K2) = 100.*SOCCHE/TOTFLX
         if (SOCCHE.eq.0.0) then
            write (RPTLUN(MACHNO),5130)
         else
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCCHE
            write (RPTLUN(MACHNO),5130) SOCCHE,CHEMPC(K2),HAFLT
         endif
5130     format ('   All Chemical Processes',:,3X,1PG11.4,4X,0PF6.2,4X, 
     &      1PG11.4)
         if (SOCBIO(1).eq.0.0) then
            write (RPTLUN(MACHNO),5140)
         else
            PERCET = 100.*SOCBIO(1)/TOTFLX
            HAFLW = 0.69315*(Z(5,K2)+Z(6,K2))/SOCBIO(1)
            write (RPTLUN(MACHNO),5140) SOCBIO(1),PERCET,HAFLW
         endif
5140     format (' Bacterioplankton',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (SOCBIO(2).eq.0.0) then
            write (RPTLUN(MACHNO),5150)
         else
            PERCET = 100.*SOCBIO(2)/TOTFLX
            HAFLS = 0.69315*(Z(5,K2)+Z(6,K2))/SOCBIO(2)
            write (RPTLUN(MACHNO),5150) SOCBIO(2),PERCET,HAFLS
         endif
5150     format (' Benthic Bacteria',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         TOTBIO = SOCBIO(1)+SOCBIO(2)
         BIOPCT(K2) = 100.*TOTBIO/TOTFLX
         if (TOTBIO.eq.0.0) then
            write (RPTLUN(MACHNO),5160)
         else
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/TOTBIO
            write (RPTLUN(MACHNO),5160) TOTBIO,BIOPCT(K2),HAFLT
         endif
5160     format (3X,'Total Biolysis',:,11X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         EXPPCT(K2) = 100.*SOCOUT/TOTFLX
         if (SURWAT.eq.0.0) then
            write (RPTLUN(MACHNO),5170)
         else
            PERCET = 100.*SURWAT/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SURWAT
            write (RPTLUN(MACHNO),5170) SURWAT,PERCET,HAFLT
         endif
5170     format (' Surface Water-borne Export',:,1X,1PG11.4,4X,0PF6.2,4X
     &      ,1PG11.4)
         if (GNDOUT.eq.0.0) then
            write (RPTLUN(MACHNO),5180)
         else
            PERCET = 100.*GNDOUT/TOTFLX
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SURWAT
            write (RPTLUN(MACHNO),5180) GNDOUT,PERCET,HAFLT
         endif
5180     format (' Seepage export',:,13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         VOLPCT(K2) = 100.*SOCVOL/TOTFLX
         if (SOCVOL.eq.0.0) then
            write (RPTLUN(MACHNO),5190)
         else
            HAFLT = 0.69315*(Z(5,K2)+Z(6,K2))/SOCVOL
            write (RPTLUN(MACHNO),5190) SOCVOL,VOLPCT(K2),HAFLT
         endif
5190     format (' Volatilization',:,13X,1PG11.4,4X,0PF6.2,4X,1PG11.4)
         if (ACTION) then
            write (RPTLUN(MACHNO),5200) TOTFLX
         else
            write (RPTLUN(MACHNO),5200)
         endif
5200     format (29X,10('=')/' Total mass flux:',:,11X,1PG11.4)
         write (RPTLUN(MACHNO),5220)
         write (RPTLUN(MACHNO),5210)
5210  format (' * Pseudo-first-order estimates based on flux/','resident
     - mass;',/,'   assumes transport delays will not throttle fluxes.')
5220     format (1X,63('-'))
         write(RPTLUN(MACHNO),5000) VERSN,MODEG,(ECONAM(IV),IV=1,III(1))
         write (RPTLUN(MACHNO),5020) (CHEMNA(IV,K2),IV=1,III(2))
         write (RPTLUN(MACHNO),5030)
         I = int(TENDG)
         write (RPTLUN(MACHNO),5230) KOUT,I,NAMTIM(TCODEG)
5230     format (' Table 20.',A2,'.  Exposure analysis at the elapse of'
     &      ,I5,1X,A7)
         write (RPTLUN(MACHNO),5220)
         PCTWAT = 0.0
         PCTSED = 0.0
         QTSAV(K2) = Z(5,K2)+Z(6,K2)
         QWSAV(K2) = Z(5,K2)
         QSSAV(K2) = Z(6,K2)
         if (QTSAV(K2).eq.0.0) go to 150
         PCTWAT = 100.*QWSAV(K2)/QTSAV(K2)
         PCTSED = 100.*QSSAV(K2)/QTSAV(K2)
150      continue
         write (RPTLUN(MACHNO),5240)
5240  format (1X,'Exposure Concentrations:',/1X,23('=')/8X,'Water Column
     &:')
         write (RPTLUN(MACHNO),5250) DOMAX(1,K2)
5250     format (10X,'Total (mg/L)',1X,11(' .'),2X,1PG10.3)
         write (RPTLUN(MACHNO),5260) DOMAX(2,K2)
5260     format (10X,'Dissolved (mg/L)',1X,9(' .'),2X,1PG10.3)
         write (RPTLUN(MACHNO),5270) DOMAX(4,K2)
5270     format (10X,'Plankton (ug/g dry)',8(' .'),2X,1PG10.3)
         write (RPTLUN(MACHNO),5280) DOMAX(6,K2)
5280     format (8X,'Benthic Sediments:'/10X,'Total (mg/kg dry)',9(' .')
     &      ,2X,1PG10.3)
         write (RPTLUN(MACHNO),5290) DOMAX(7,K2)
5290     format (10X,'Dissolved (mg/L pore)',7(' .'),2X,1PG10.3)
         write (RPTLUN(MACHNO),5300) DOMAX(9,K2)
5300     format (10X,'Benthos (ug/g dry)',1X,8(' .'),2X,1PG10.3)
         write (RPTLUN(MACHNO),5310) QTSAV(K2),PCTWAT,PCTSED
5310  format (/1X,'Fate:  Current Resident Mass -- kg',12X,1PG10.3,/' ==
     &==',6X,'Water Column',12(' .'),3X,0PF7.2,' %'/11X,'Benthic Sedimen
     &ts',1X,9(' .'),3X,0PF7.2,' %')
         if (ACTION) then
            write (RPTLUN(MACHNO),5320) NAMTIM(TCODEG),TOTFLX
         else
            write (RPTLUN(MACHNO),5320) NAMTIM(TCODEG)
         endif
5320     format (8X,'Total Flux of Chemical -- kg /',A5,:,4X,1PG10.3)
         write (RPTLUN(MACHNO),5330) CHEMPC(K2),BIOPCT(K2),VOLPCT(K2),
     &      EXPPCT(K2)
5330  format (11X,'Chemical Transformations: ',5(' .'),2X,F8.2,' %'/11X,
     &'Biological Transformations: ',4(' .'),2X,F8.2,' %'/11X,'Volatiliz
     &ation: ',10(' .'),2X,F8.2,' %'/11X,'Water-borne Export: ',8(' .'),
     &2X,F8.2,' %')
160   continue
      return
      end
