      subroutine AVEOUT(Y)
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'LOCAL1.INC'
      include 'LOCAL2.INC'
      dimension Y(KOUNT,KCHEM)
      double precision Y
      real OUTDAT(6), PERCET, TOTMAS, DOMIN(10)
      integer ICHEK, ISTART, K1, NTAB, M1, M2
      integer I, J, K, KK, II, IONTES, NTABLE, N1
      integer KKNTW, KKNTS, III(2), IV, VRAIL
      integer IALPHA(7), MAXPT(10), MINPT(10)
      integer IFIRST(2), ILAST(2)
      logical FIRSTW, FIRSTB
      character*1 NTYPX(5), NTYPN(5)
      character KOUT*2, OUTLIN(2)*64, STAR*1
      character ITOP(4)*4, PIECE(7)*4
      data IALPHA/25,21,17,1,5,9,13/
      data STAR/'*'/
      data PIECE /'(-3)','(-2)','(-1)',' (0)','(+1)','(+2)','(+3)'/
5000  format ('1','Exposure Analysis Modeling System -- EXAMS Version ',
     &   F4.2,', Mode',I2/' Ecosystem: ',50A1)
5010  format (' Chemical:  ',50A1)
5020  format (1X,63('-'))
      if (MACHNO.eq.11) then
         open (unit=SSLUN(MACHNO),status='new',access='sequential',form=
     &      'unformatted',file='SSOUT.PLT')
      else
         open (unit=SSLUN(MACHNO),status='unknown',access='sequential',
     &      form='unformatted',file='SSOUT.PLT')
         if (.not.(TOPOPN(MACHNO))) rewind SSLUN(MACHNO)
      endif
      write (SSLUN(MACHNO)) KCHEM,MODEG,KOUNT
      do 100 KK = 1, KCHEM
         write (SSLUN(MACHNO)) (CHEMNA(I,KK),I=1,50)
100   continue
      write (SSLUN(MACHNO)) (ECONAM(I),I=1,50)
      if (KOUNTS.eq.0.0) KOUNTS = 1.0
      if (KOUNTW.eq.0.0) KOUNTW = 1.0
      KKNTW = ifix(KOUNTW)
      KKNTS = ifix(KOUNTS)
      III(1) = VRAIL(ECONAM)
      do 460 KK = 1, KCHEM
         do 110 I = 1, 6
            Z(I,KK) = 0.0
110      continue
         do 120 I = 1, 12
            Z2(I) = 0.
120      continue
         FIRSTW = .true.
         FIRSTB = .true.
         III(2) = VRAIL(CHEMNA(1,KK))
         do 140 J = 1, KOUNT
            if (TYPEG(J).eq.'B') go to 130
            Z(1,KK) = Z(1,KK)+(ALPHA(29,J,KK)+ALPHA(31,J,KK))*Y(J,KK)
            Z(2,KK) = Z(2,KK)+ALPHA(30,J,KK)*Y(J,KK)/SEDCOL(J)
            Z(5,KK) = Z(5,KK)+Y(J,KK)*WATVOL(J)*1.0E-06
            go to 140
130         continue
            Z(3,KK) = Z(3,KK)+(ALPHA(29,J,KK)+ALPHA(31,J,KK))*Y(J,KK)
            Z(4,KK) = Z(4,KK)+ALPHA(30,J,KK)*Y(J,KK)/SEDCOL(J)
            Z(6,KK) = Z(6,KK)+Y(J,KK)*WATVOL(J)*1.0E-06
140      continue
         Z(1,KK) = Z(1,KK)/KOUNTW
         Z(2,KK) = Z(2,KK)/KOUNTW
         Z(3,KK) = Z(3,KK)/KOUNTS
         Z(4,KK) = Z(4,KK)/KOUNTS
         write (RPTLUN(MACHNO),5000) VERSN,MODEG,(ECONAM(IV),IV=1,III(1)
     &      )
         write (RPTLUN(MACHNO),5010) (CHEMNA(IV,KK),IV=1,III(2))
         write (RPTLUN(MACHNO),5020)
         write (KOUT,5030) KK
5030     format (I2)
         if (KOUT(1:1).eq.' ') KOUT(1:1) = '0'
         write (RPTLUN(MACHNO),5040) KOUT
5040  format (' Table 15.',A2,'.  Distribution of chemical at steady sta
     &te.')
         write (RPTLUN(MACHNO),5050)
5050     format (1X,63('-'))
         write (RPTLUN(MACHNO),5060)
5060  format (' Seg',2X,'Resident Mass',3X,8('*'),1X,'Chemical Concentra
     &tions',1X,9('*'))
         write (RPTLUN(MACHNO),5070)
5070  format ('  #',21X,'Total',4X,'Dissolved',2X,'Sediments',4X,'Biota'
     &)
         write (RPTLUN(MACHNO),5080)
5080     format (6X,'Kilos',6X,'%',7X,'mg/*',5X,'mg/L **',5X,'mg/kg',7X,
     &      'ug/g')
         write (RPTLUN(MACHNO),5090)
5090     format (1X,3('-'),1X,8('-'),1X,6('-'),4(2X,9('-')))
         write (RPTLUN(MACHNO),5100)
5100     format (' In the Water Column:')
         do 190 J = 1, KOUNT
            if (TYPEG(J).eq.'B') go to 190
            Z2(6) = 1.0E-06*Y(J,KK)*WATVOL(J)
            Z2(5) = 1.0E+03*Z2(6)/AREAG(J)
            Z2(7) = Z2(7)+Z2(5)
            PERCET = 0.0
            if (Z(5,KK).ne.0.0) PERCET = Z2(6)*100./Z(5,KK)
            Z2(1) = Y(J,KK)
            Z2(8) = Z2(8)+Z2(1)
            Z2(2) = (ALPHA(29,J,KK)+ALPHA(31,J,KK))*Y(J,KK)
            Z2(3) = ALPHA(30,J,KK)*Y(J,KK)/SEDCOL(J)
            Z2(4) = ALPHA(32,J,KK)*Y(J,KK)/BIOTOL(J)
            Z2(9) = Z2(9)+Z2(4)
            if (.not.FIRSTW) go to 160
            do 150 I = 1, 5
               MAXPT(I) = J
               MINPT(I) = J
               DOMAX(I,KK) = Z2(I)
               DOMIN(I) = Z2(I)
150         continue
            FIRSTW = .false.
            go to 180
160         continue
            do 170 I = 1, 5
               if (Z2(I).gt.DOMAX(I,KK)) MAXPT(I) = J
               if (Z2(I).lt.DOMIN(I)) MINPT(I) = J
               DOMAX(I,KK) = amax1(DOMAX(I,KK),Z2(I))
               DOMIN(I) = amin1(DOMIN(I),Z2(I))
170         continue
180         continue
            write (RPTLUN(MACHNO),5110) J,Z2(6),PERCET,(Z2(I),I=1,4)
            write (SSLUN(MACHNO)) KK,J,TYPEG(J),Z2(5),Z2(6),PERCET,(Z2(I
     &         ),I=1,4)
190      continue
         write (SSLUN(MACHNO)) KK,KKNTW,STAR,(Z(I,KK),I=1,6),Z2(1)
5110     format (1X,I3,1PG9.2,1X,0PF6.2,1X,1PG10.3,3(1X,G10.3))
         Z2(7) = Z2(7)/KOUNTW
         Z2(8) = Z2(8)/KOUNTW
         Z2(9) = Z2(9)/KOUNTW
         PERCET = 0.0
         if (Z(5,KK).ne.0.0.or.Z(6,KK).ne.0.0) PERCET = 100.*Z(5,KK)/(Z(
     &      5,KK)+Z(6,KK))
         write (RPTLUN(MACHNO),5120) Z(5,KK),PERCET
5120     format (5X,8('='),1X,6('=')/4X,1PG9.2,1X,0PF6.2)
         write (RPTLUN(MACHNO),5130)
5130     format (/'  and in the Benthic Sediments:')
         do 240 J = 1, KOUNT
            if (TYPEG(J).ne.'B') go to 240
            Z2(6) = 1.0E-06*Y(J,KK)*WATVOL(J)
            Z2(5) = 1.E3*Z2(6)/AREAG(J)
            Z2(10) = Z2(10)+Z2(5)
            PERCET = 0.0
            if (Z(6,KK).ne.0.0) PERCET = 100.*Z2(6)/Z(6,KK)
            Z2(1) = Y(J,KK)*WATVOL(J)/SEDMSL(J)
            Z2(11) = Z2(11)+Z2(1)
            Z2(2) = (ALPHA(29,J,KK)+ALPHA(31,J,KK))*Y(J,KK)
            Z2(3) = ALPHA(30,J,KK)*Y(J,KK)/SEDCOL(J)
            Z2(4) = ALPHA(32,J,KK)*Y(J,KK)/BIOTOL(J)
            Z2(12) = Z2(12)+Z2(4)
            if (.not.FIRSTB) go to 210
            do 200 I = 6, 10
               MAXPT(I) = J
               MINPT(I) = J
               DOMAX(I,KK) = Z2(I-5)
               DOMIN(I) = Z2(I-5)
200         continue
            FIRSTB = .false.
            go to 230
210         continue
            do 220 I = 6, 10
               if (Z2(I-5).gt.DOMAX(I,KK)) MAXPT(I) = J
               if (Z2(I-5).lt.DOMIN(I)) MINPT(I) = J
               DOMAX(I,KK) = amax1(DOMAX(I,KK),Z2(I-5))
               DOMIN(I) = amin1(DOMIN(I),Z2(I-5))
220         continue
230         continue
            write (RPTLUN(MACHNO),5110) J,Z2(6),PERCET,(Z2(I),I=1,4)
            write (SSLUN(MACHNO)) KK,J,TYPEG(J),Z2(5),Z2(6),PERCET,
     &                            (Z2(I),I=1,4)
240      continue
         write (SSLUN(MACHNO)) KK,KKNTS,STAR,(Z(I,KK),I=1,6),Z2(1)
         Z2(10) = Z2(10)/KOUNTS
         Z2(11) = Z2(11)/KOUNTS
         Z2(12) = Z2(12)/KOUNTS
         PERCET = 0.0
         if (Z(5,KK).ne.0.0.or.Z(6,KK).ne.0.0) PERCET = Z(6,KK)*100./(Z(
     &      5,KK)+Z(6,KK))
         write (RPTLUN(MACHNO),5120) Z(6,KK),PERCET
         TOTMAS = Z(5,KK)+Z(6,KK)
         write (RPTLUN(MACHNO),5140) TOTMAS
5140     format (1X,'Total Mass (kilograms) =',3X,1PG11.4)
         write (RPTLUN(MACHNO),5050)
         write (RPTLUN(MACHNO),5150)
5150  format ('  * Units: mg/L in Water Column; mg/kg in Benthos.'/     
     &' ** Includes complexes with "dissolved" organics.')
         IONTES = 0
         do 250 II = 1, 7
            if (SPFLGG(II,KK).eq.1) IONTES = IONTES+1
250      continue
         NTABLE = 1
         if (IONTES.gt.4) NTABLE = 2
         ISTART = 0
         do 260 ICHEK = 7, 5, -1
            ISTART = ISTART+1
            if (SPFLGG(ICHEK,KK).eq.1) go to 280
260      continue
         do 270 ICHEK = 1, 4
            ISTART = ISTART+1
            if (SPFLGG(ICHEK,KK).eq.1) go to 280
270      continue
         write (TTYOUT(MACHNO),5160)
5160  format (1X,'Code malfunction in speciation section of'/' subroutin
     &e AVEOUT.  Please report problem to author.')
         IFLAG = 8
         go to 470
280      continue
         IFIRST(1) = ISTART
         if (IONTES.gt.4) go to 290
         ILAST(1) = ISTART+IONTES-1
         go to 300
290      continue
         ILAST(1) = ISTART+3
         IFIRST(2) = ISTART+4
         ILAST(2) = IFIRST(2)+IONTES-5
300      continue
         do 370 NTAB = 1, NTABLE
            write (RPTLUN(MACHNO),5000) VERSN,MODEG,(ECONAM(IV),IV=1,III
     &         (1))
            write (RPTLUN(MACHNO),5010) (CHEMNA(IV,KK),IV=1,III(2))
            write (RPTLUN(MACHNO),5020)
            write (RPTLUN(MACHNO),5170) KOUT,NTAB
5170  format (' Table 16.',A2,'.',I1,'.  ','Steady-state concentration d
     &istribution among'/' aqueous chemical species.  All concentrations
     & in ug/L (ppb).')
            write (RPTLUN(MACHNO),5050)
            write (RPTLUN(MACHNO),5180)
5180        format (1X,'Seg',1X,'T*',1X,'  Total  ','    DOC   ',3X,'-',
     &         1X,'Chemical Species (by valency)',1X,'-')
            do 310 I = 1, 4
               ITOP(I) = '    '
310         continue
            K1 = 1
            do 320 K = IFIRST(NTAB), ILAST(NTAB)
               ITOP(K1) = PIECE(K)
               K1 = K1+1
320         continue
            write (RPTLUN(MACHNO),5190) (ITOP(I),I=1,4)
5190        format (2X,'#',2X,'y',1X,'  Aqueous ',' Complexed',4X,A4,5X,
     &         A4,5X,A4,5X,A4)
            write (RPTLUN(MACHNO),5050)
            do 360 J = 1, KOUNT
               OUTDAT(1) = 1000.*(ALPHA(29,J,KK)+ALPHA(31,J,KK))*Y(J,KK)
               do 330 I = 2, 6
                  OUTDAT(I) = 0.0
330            continue
               OUTDAT(2) = 1000.0*ALPHA(31,J,KK)*Y(J,KK)
               N1 = 3
               do 340 I = IFIRST(NTAB), ILAST(NTAB)
                  OUTDAT(N1) = 1000.0*ALPHA(IALPHA(I),J,KK)*Y(J,KK)
                  N1 = N1+1
340            continue
               write (OUTLIN(1),5200) J,TYPEG(J),(OUTDAT(I),I=1,6)
5200           format (1X,I3,1X,A1,1X,1PG10.3,G10.3,1X,4G9.2)
               if (OUTDAT(2).eq.0.0) OUTLIN(1)(18:27) = '          '
               N1 = 3
               do 350 I = 29, 56, 9
                  if (OUTDAT(N1).eq.0.0) OUTLIN(1)(I:I+8) = '         '
                  N1 = N1+1
350            continue
               write (RPTLUN(MACHNO),5210) OUTLIN(1)
5210           format (A64)
360         continue
            write (RPTLUN(MACHNO),5050)
            write (RPTLUN(MACHNO),5220)
370      continue
5220  format (                                                          
     &'  * Segment types: Littoral, Epilimnetic, Hypolimnetic, Benthic.'
     &)
         write(RPTLUN(MACHNO),5000) VERSN,MODEG,(ECONAM(IV),IV=1,III(1))
         write (RPTLUN(MACHNO),5010) (CHEMNA(IV,KK),IV=1,III(2))
         write (RPTLUN(MACHNO),5020)
         write (RPTLUN(MACHNO),5230) KOUT
5230  format (' Table 17.',A2,'. Steady-state concentration means and ex
     &trema.'/' Number in parens (Seg) indicates segment where value was
     & found.')
         write (RPTLUN(MACHNO),5050)
         write (RPTLUN(MACHNO),5240)
5240  format (9X,'Total',9X,'Dissolved',5X,'Sediments',7X,'Biota',/,6X,'
     &Seg   mg/*',5X,'Seg  mg/L **',3X,'Seg  mg/kg',5X,'Seg  ug/gram',/ 
     &4X,4('  -------------')/' Water Column:')
         write (RPTLUN(MACHNO),5250) Z2(8),Z(1,KK),Z(2,KK),Z2(9)
5250     format (' Mean',4X,1PG10.3,3(5X,G10.3))
         write (SSLUN(MACHNO)) KK,Z2(8),Z(1,KK),Z(2,KK),Z2(9),Z2(7)
         write (OUTLIN(1),5260) (MAXPT(I),DOMAX(I,KK),I=1,4)
5260     format (' Max',4(1X,I3,')',1PG10.3))
         do 380 J = 1, 5
            NTYPX(J) = TYPEG(MAXPT(J))
            NTYPN(J) = TYPEG(MINPT(J))
380      continue
         write (SSLUN(MACHNO)) KK,(MAXPT(I),I=1,5),NTYPX,(DOMAX(I,KK),I=
     &      1,5)
         write (OUTLIN(2),5270) (MINPT(I),DOMIN(I),I=1,4)
5270     format (' Min',4(1X,I3,')',1PG10.3))
         write (SSLUN(MACHNO))KK,(MINPT(I),I=1,5),NTYPN,(DOMIN(I),I=1,5)
         do 410 I = 1, 2
            do 400 M1 = 7, 52, 15
               do 390 M2 = M1, M1-2, -1
                  if (OUTLIN(I)(M2:M2).ne.' ') go to 390
                  OUTLIN(I)(M2:M2) = '('
                  go to 400
390            continue
400         continue
            write (RPTLUN(MACHNO),5210) OUTLIN(I)
410      continue
         write (RPTLUN(MACHNO),5280)
5280     format (/1X,'Benthic Sediments:')
         write (RPTLUN(MACHNO),5250) Z2(11),Z(3,KK),Z(4,KK),Z2(12)
         write (SSLUN(MACHNO)) KK,Z2(11),Z(3,KK),Z(4,KK),Z2(12),Z2(10)
         write (OUTLIN(1),5260) (MAXPT(I),DOMAX(I,KK),I=6,9)
         do 420 J = 6, 10
            NTYPX(J-5) = TYPEG(MAXPT(J))
            NTYPN(J-5) = TYPEG(MINPT(J))
420      continue
         write (SSLUN(MACHNO)) KK,(MAXPT(I),I=6,10),NTYPX,(DOMAX(I,KK),I
     &      =6,10)
         write (OUTLIN(2),5270) (MINPT(I),DOMIN(I),I=6,9)
         write (SSLUN(MACHNO)) KK,(MINPT(I),I=6,10),NTYPN,(DOMIN(I),I=6,
     &      10)
         do 450 I = 1, 2
            do 440 M1 = 7, 52, 15
               do 430 M2 = M1, M1-2, -1
                  if (OUTLIN(I)(M2:M2).ne.' ') go to 430
                  OUTLIN(I)(M2:M2) = '('
                  go to 440
430            continue
440         continue
            write (RPTLUN(MACHNO),5210) OUTLIN(I)
450      continue
         write (RPTLUN(MACHNO),5050)
         write (RPTLUN(MACHNO),5150)
460   continue
470   continue
      close (unit=SSLUN(MACHNO))
      return
      end
