      subroutine WATADV(TOTIN,WATINL)
      include 'SIZE.INC'
      include 'GLOBAL.INC'
      include 'LOCAL.INC'
      include 'UNITS.INC'
      include 'LOCAL1.INC'
      include 'LOCAL2.INC'
      double precision AMAT(NPX,NPX1), SAVER
      integer I, J, K, KK, KEXCH, KOUNT1, LL, M, N
      real COLTOT, TOTOUT, COLTST, TOTIN, WATINL(NPX)
      do 120 J = 1, KOUNT
         WATOUL(J) = 0.
         SEDOUL(J) = 0.
         do 110 I = 1, KOUNT
            WATFL(I,J) = 0.
            do 100 K = 1, KCHEM
               SEDFL(I,J,K) = 0.
100         continue
110      continue
120   continue
      do 170 K = 1, NCON
         J = JFRADG(K)
         I = ITOADG(K)
         if (J.ge.0.and.I.ge.0) go to 130
         write (TTYOUT(MACHNO),5000)
         go to 380
130      continue
         if (.not.(J.eq.0.and.I.ne.0)) go to 140
         write (TTYOUT(MACHNO),5010) I
         go to 380
140      continue
         if (J.eq.0.and.I.eq.0) go to 170
         if (J.le.KOUNT.and.I.le.KOUNT) go to 150
         write (TTYOUT(MACHNO),5020) J,I,KOUNT
         go to 380
150      continue
         if (I.eq.0) WATOUL(J) = WATOUL(J)+ADVPRG(K)
         if (I.ne.0) WATFL(I,J) = ADVPRG(K)
         if (J.eq.I) write (TTYOUT(MACHNO),5030) J
         if (I.eq.0) go to 170
         do 160 KK = 1, NCON
            if (JFRADG(KK).eq.I) go to 170
160      continue
         write (TTYOUT(MACHNO),5040) I,J,I
         go to 380
170   continue
5000  format (1X,'A negative segment number was entered for ','advective
     & flow.'/1X,'Simulation aborted.')
5010  format (1X,'Please load inputs to the system via stream','flows,'/
     &1X,'non-point-source flows, etc.'/1X,'Simulation ','aborted.  Remo
     &ve the (0,',I4,') advective pair.')
5020  format (1X,'Advection from element ',I4,' to element ',I4/1X,'is n
     &ot possible -- only ',I4,' are available.'/1X,'System aborted.')
5030  format (1X,'The specifications for advective flows included',' an 
     &internal'/1X,'recycle in segment ',I4,'.'/1X,'This may generate a 
     &system abort.')
5040  format (1X,'System definition error-'/1X,'segment ',I4,' receives 
     &an advected flow from segment ',I4,','/1X,'but the route of releas
     &e of this flow from segment',I4/1X,'has not been specified.  Simul
     &ation aborted.')
      do 180 J = 1, KOUNT
         WATFL(J,J) = 0.
180   continue
      TOTOUT = 0.
      do 200 J = 1, KOUNT
         COLTOT = WATOUL(J)
         TOTOUT = TOTOUT+WATOUL(J)
         do 190 I = 1, KOUNT
            COLTOT = COLTOT+WATFL(I,J)
190      continue
         if (COLTOT.eq.0.) go to 200
         COLTST = abs(COLTOT-1.0)
         if (COLTST.le.1.E-5) go to 200
         write (TTYOUT(MACHNO),5050) J
         go to 380
200   continue
5050  format (1X,'System definition error--advective transport in ',' se
     &gment'/1X,I4,' does not conserve mass.  Simulation',' aborted.')
      if (TOTOUT.gt.0.) go to 210
      if (TOTIN.lt.1.E-4) go to 210
      write (TTYOUT(MACHNO),5060)
      go to 380
5060  format (1X,'System definition error -- no outlet flows provided;',
     &' evaporation'/1X,'does not balance the water budget.  ','Simulati
     &on aborted.')
210   continue
      do 230 J = 1, KOUNT
         do 220 I = 1, KOUNT
            AMAT(I,J) = -WATFL(I,J)
220      continue
         AMAT(J,J) = 1.0
230   continue
      KOUNT1 = KOUNT+1
      do 240 J = 1, KOUNT
         AMAT(J,KOUNT1) = 0.00
         if (TOTIN.ne.0.) AMAT(J,KOUNT1) = WATINL(J)/TOTIN
240   continue
      do 330 I = 1, KOUNT
         KEXCH = 1
         M = I+1
250      continue
         if (dabs(AMAT(I,I)).gt.1.E-05) go to 280
         LL = I+KEXCH
         if (LL-KOUNT) 260, 260, 340
260      continue
         do 270 N = I, KOUNT1
            SAVER = AMAT(I,N)
            AMAT(I,N) = AMAT(LL,N)
            AMAT(LL,N) = SAVER
270      continue
         KEXCH = KEXCH+1
         go to 250
280      continue
         do 290 J = M, KOUNT1
            AMAT(I,J) = AMAT(I,J)/AMAT(I,I)
290      continue
         do 320 J = 1, KOUNT
            if (J-I) 300, 320, 300
300         continue
            do 310 K = M, KOUNT1
               AMAT(J,K) = AMAT(J,K)-AMAT(J,I)*AMAT(I,K)
310         continue
320      continue
330   continue
      go to 350
340   continue
      write (TTYOUT(MACHNO),5070)
5070  format (1X,'System failure--advective transport field'/1X,'cannot 
     &be defined.  Simulation aborted.')
      go to 380
350   continue
      do 370 J = 1, KOUNT
         WATOUL(J) = WATOUL(J)*TOTIN*AMAT(J,KOUNT1)
         do 360 I = 1, KOUNT
            WATFL(I,J) = WATFL(I,J)*TOTIN*AMAT(J,KOUNT1)
360      continue
370   continue
      go to 390
380   continue
      IFLAG = 8
390   return
      end
